// package com.digiwin.dap.middle.encrypt.config;
//
// import com.digiwin.dap.middle.encrypt.constant.EncryptConstants;
// import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
// import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
// import com.digiwin.dap.middleware.commons.crypto.AES;
// import com.digiwin.dap.middleware.commons.crypto.SignUtils;
// import com.digiwin.dap.middleware.domain.StdData;
// import com.digiwin.dap.middleware.domain.StdDataEncrypt;
// import com.digiwin.dap.middleware.util.JsonUtils;
// import org.springframework.beans.BeanUtils;
// import org.springframework.core.MethodParameter;
// import org.springframework.core.annotation.AnnotationUtils;
// import org.springframework.http.MediaType;
// import org.springframework.http.converter.HttpMessageConverter;
// import org.springframework.http.server.ServerHttpRequest;
// import org.springframework.http.server.ServerHttpResponse;
// import org.springframework.http.server.ServletServerHttpRequest;
// import org.springframework.web.bind.annotation.ControllerAdvice;
// import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
//
// import javax.servlet.http.HttpServletRequest;
//
// /**
//  * 加密加签 响应处理
//  * <p>
//  * 根据验签、解密的标记，自动加密、加签
//  *
//  * @author ChenZhuang
//  * @date 2024 -3-7 14:12:18
//  */
// @ControllerAdvice
// public class EncryptResponse implements ResponseBodyAdvice<Object> {
//     @Override
//     public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
//         return returnType.hasMethodAnnotation(DapEncrypt.class) || AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), DapEncrypt.class) != null
//                 || returnType.hasMethodAnnotation(DapSign.class) || AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), DapSign.class) != null;
//     }
//
//     @Override
//     public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
//         if (null == body) {
//             return body;
//         }
//         StdData result = null;
//         if (body instanceof StdData) {
//             result = (StdData) body;
//             if (null == result.getData()) {
//                 return body;
//             }
//         }
//         HttpServletRequest req = ((ServletServerHttpRequest) request).getServletRequest();
//         DapEncrypt dapEncrypt = AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), DapEncrypt.class);
//         if (dapEncrypt == null) {
//             dapEncrypt = returnType.getMethodAnnotation(DapEncrypt.class);
//         }
//         if (dapEncrypt != null && dapEncrypt.responseEncrypt()) {
//             String appSecret = (String) req.getAttribute(EncryptConstants.APP_SECRET_KEY);
//             String dataString;
//             if (BeanUtils.isSimpleProperty(body.getClass())) {
//                 dataString = body.toString();
//             } else {
//                 dataString = JsonUtils.objToJson(body);
//             }
//             String eData = AES.encryptIvCBC(dataString, appSecret);
//             if (null == result) {
//                 result = StdData.of(true);
//             }
//             result.setData(eData);
//         }
//         DapSign dapSign = AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), DapSign.class);
//         if (dapSign == null) {
//             dapSign = returnType.getMethodAnnotation(DapSign.class);
//         }
//         if (dapSign != null && dapSign.responseSign()) {
//             StdDataEncrypt<Object> dataEncrypt = new StdDataEncrypt<>();
//             if (null == result) {
//                 result = StdData.of(true);
//                 dataEncrypt.setCode(result.getCode());
//                 dataEncrypt.setMessage(result.getMessage());
//                 dataEncrypt.setSuccess(result.isSuccess());
//                 dataEncrypt.setData(body);
//             } else {
//                 dataEncrypt.setCode(result.getCode());
//                 dataEncrypt.setMessage(result.getMessage());
//                 dataEncrypt.setSuccess(result.isSuccess());
//                 dataEncrypt.setData(result.getData());
//             }
//             String appSecret = (String) req.getAttribute(EncryptConstants.APP_SECRET_KEY);
//             String dataString;
//             if (result.getData() == null) {
//                 dataString = "";
//             } else if (BeanUtils.isSimpleProperty(result.getData().getClass())) {
//                 dataString = result.getData().toString();
//             } else {
//                 dataString = SignUtils.sortParam(result.getData());
//             }
//             String sign = SignUtils.sign(appSecret, dataString);
//             dataEncrypt.setSign(sign);
//             result = dataEncrypt;
//         }
//         return null == result ? body : result;
//     }
// }
