package com.digiwin.dap.middle.encrypt.support;

/**
 * 获取appSecret
 *
 * @author ChenZhuang
 * @date @date 2024-1-22 17:14:07
 */
public interface DapSecretSupport {

    /**
     * 获取应用的密钥信息
     *
     * @param userToken 用户token
     * @param appToken  应用token
     * @return appSecret
     */
    String getAppSecret(String userToken, String appToken);

    /**
     * 获取开发商密钥
     *
     * @param userToken 用户token
     * @param devKey    密钥对ID
     * @return devSecret
     */
    String getDevSecret(String userToken, String devKey);

}
