package com.digiwin.dap.middle.encrypt.domain.annotation;

import java.lang.annotation.*;

/**
 * 接口签名注解
 *
 * @author ChenZhuang
 * @date 2024-01-09 18:14:20
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DapSign {

    /**
     * 强制验签<br>
     * true: 不管是否传递签名头，都要验证签名<br>
     * false: 不传签名头就不验证，传就验证
     *
     * @return boolean
     */
    boolean force() default true;

    /**
     * 请求参数是否加签，默认加签
     * true: 按force规则
     * false: 不管是否传签名头，都不验证
     *
     * @return boolean
     */
    boolean request() default true;

    /**
     * 响应结果是否加签，默认不加签
     *
     * @return boolean
     */
    boolean response() default false;

    /**
     * 是否允许重复请求，默认不允许
     *
     * @return boolean
     */
    boolean resubmit() default false;
}