package com.digiwin.dap.middle.encrypt.domain.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 接口加密注解
 *
 * @author ChenZhuang
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface DapEncrypt {

    /**
     * 强制加密
     *
     * @return boolean
     */
    boolean force() default true;

    /**
     * 响应结果是否加密，默认不加密
     *
     * @return boolean
     */
    boolean response() default false;
}
