/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.config;

import com.digiwin.dap.middle.encrypt.AnnotationUtil;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.domain.StdDataEncrypt;
import com.digiwin.dap.middleware.util.JsonUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseEntityEncryptResponse
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean hasAnnotation = AnnotationUtil.getAnnotation(returnType, DapEncrypt.class) != null || AnnotationUtil.getAnnotation(returnType, DapSign.class) != null;
        boolean isResponseTypeSupported = ResponseEntity.class.isAssignableFrom(returnType.getParameterType());
        return hasAnnotation && isResponseTypeSupported;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        DapSign dapSign;
        if (body == null) {
            return null;
        }
        HttpServletRequest req = ((ServletServerHttpRequest)request).getServletRequest();
        boolean encrypt = false;
        StdData result = StdData.ok((Object)body);
        DapEncrypt dapEncrypt = AnnotationUtil.getAnnotation(returnType, DapEncrypt.class);
        if (dapEncrypt != null && dapEncrypt.response()) {
            String appSecret = (String)req.getAttribute("appSecret");
            String dataString = BeanUtils.isSimpleProperty(body.getClass()) ? body.toString() : JsonUtils.objToJson((Object)body);
            String eData = AES.encryptIvCBC((String)dataString, (String)appSecret);
            result.setData((Object)eData);
            encrypt = true;
        }
        if ((dapSign = AnnotationUtil.getAnnotation(returnType, DapSign.class)) != null && dapSign.response()) {
            StdDataEncrypt dataEncrypt = new StdDataEncrypt();
            dataEncrypt.setCode(result.getCode());
            dataEncrypt.setMessage(result.getMessage());
            dataEncrypt.setSuccess(result.getSuccess());
            dataEncrypt.setData(result.getData());
            String appSecret = (String)req.getAttribute("appSecret");
            String dataString = BeanUtils.isSimpleProperty(result.getData().getClass()) ? result.getData().toString() : SignUtils.sortParam((Object)result.getData());
            String sign = SignUtils.sign((String)appSecret, (String)dataString);
            dataEncrypt.setSign(sign);
            result = dataEncrypt;
            encrypt = true;
        }
        return encrypt ? result : body;
    }
}

