/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.config;

import com.digiwin.dap.middle.encrypt.AnnotationUtil;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.domain.StdDataEncrypt;
import com.digiwin.dap.middleware.util.JsonUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class StdDataEncryptResponse
implements ResponseBodyAdvice<StdData> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean hasAnnotation = AnnotationUtil.getAnnotation(returnType, DapEncrypt.class) != null || AnnotationUtil.getAnnotation(returnType, DapSign.class) != null;
        boolean isResponseTypeSupported = StdData.class.isAssignableFrom(returnType.getParameterType());
        return hasAnnotation && isResponseTypeSupported;
    }

    public StdData<?> beforeBodyWrite(StdData body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        DapSign dapSign;
        if (body == null || body.getData() == null) {
            return body;
        }
        HttpServletRequest req = ((ServletServerHttpRequest)request).getServletRequest();
        DapEncrypt dapEncrypt = AnnotationUtil.getAnnotation(returnType, DapEncrypt.class);
        if (dapEncrypt != null && dapEncrypt.response()) {
            String appSecret = (String)req.getAttribute("appSecret");
            String dataString = BeanUtils.isSimpleProperty(body.getData().getClass()) ? body.getData().toString() : JsonUtils.objToJson((Object)body.getData());
            String eData = AES.encryptIvCBC((String)dataString, (String)appSecret);
            body.setData((Object)eData);
        }
        if ((dapSign = AnnotationUtil.getAnnotation(returnType, DapSign.class)) != null && dapSign.response()) {
            StdDataEncrypt dataEncrypt = new StdDataEncrypt();
            dataEncrypt.setCode(body.getCode());
            dataEncrypt.setMessage(body.getMessage());
            dataEncrypt.setSuccess(body.getSuccess());
            dataEncrypt.setData(body.getData());
            String appSecret = (String)req.getAttribute("appSecret");
            String dataString = BeanUtils.isSimpleProperty(body.getData().getClass()) ? body.getData().toString() : SignUtils.sortParam((Object)body.getData());
            String sign = SignUtils.sign((String)appSecret, (String)dataString);
            dataEncrypt.setSign(sign);
            body = dataEncrypt;
        }
        return body;
    }
}

