/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.filter;

import cn.hutool.extra.servlet.ServletUtil;
import com.digiwin.dap.middle.encrypt.AnnotationUtil;
import com.digiwin.dap.middle.encrypt.config.EncryptRequestWrapper;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEncrypt;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.DapSign;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.digiwin.dap.middleware.util.VerifyUtils;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class EncryptRequestFilter
extends OncePerRequestFilter
implements Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptRequestFilter.class);
    private static final List<String> bodyMethodList = Arrays.asList(RequestMethod.POST.name(), RequestMethod.PUT.name());
    private final DapEnv dapEnv;
    private final DapSecretSupport dapSecretSupport;

    public EncryptRequestFilter(DapEnv dapEnv, DapSecretSupport dapSecretSupport) {
        this.dapEnv = dapEnv;
        this.dapSecretSupport = dapSecretSupport;
    }

    private static HandlerExecutionChain getHandlerExecutionChain(HttpServletRequest request) {
        HandlerExecutionChain handlerChain;
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        String mappingName = Introspector.decapitalize(RequestMappingHandlerMapping.class.getSimpleName());
        RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(mappingName, RequestMappingHandlerMapping.class);
        try {
            handlerChain = handlerMapping.getHandler(request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return handlerChain;
    }

    private static String getBodyParam(String bodyString, Method method) {
        String beanParams = null;
        if (StrUtils.isNotEmpty((String)bodyString)) {
            block0: for (int i = 0; i < method.getParameterCount(); ++i) {
                Annotation[] parameterAnnotations;
                MethodParameter mp = new MethodParameter(method, i);
                for (Annotation anno : parameterAnnotations = mp.getParameterAnnotations()) {
                    if (!(anno instanceof RequestBody) && !(anno instanceof ModelAttribute)) continue;
                    Class type = mp.getParameterType();
                    if (BeanUtils.isSimpleProperty((Class)type)) {
                        beanParams = bodyString;
                        break block0;
                    }
                    beanParams = SignUtils.sortParam((String)bodyString);
                    break block0;
                }
            }
        }
        return beanParams;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HandlerExecutionChain handlerChain = EncryptRequestFilter.getHandlerExecutionChain(request);
        if (handlerChain == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handlerChain.getHandler();
        Method method = handlerMethod.getMethod();
        com.digiwin.dap.middle.encrypt.domain.annotation.DapSign dapSign = AnnotationUtil.getAnnotation(handlerMethod, com.digiwin.dap.middle.encrypt.domain.annotation.DapSign.class);
        com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt dapEncrypt = AnnotationUtil.getAnnotation(handlerMethod, com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt.class);
        String signHeader = request.getHeader(DapHttpHeaders.APP_ARGS.getHeader());
        boolean sign = this.isSign(dapSign, signHeader);
        EncryptRequestWrapper encryptRequestWrapper = new EncryptRequestWrapper(request);
        String bodyString = encryptRequestWrapper.getBodyString();
        boolean encrypt = this.isEncrypt(request, dapEncrypt, bodyString);
        String appToken = request.getHeader(DapHttpHeaders.APP_TOKEN.getHeader());
        String userToken = request.getHeader(DapHttpHeaders.USER_TOKEN.getHeader());
        if (!sign && dapSign != null) {
            LOGGER.error("\u672a\u5904\u7406\u52a0\u7b7e\u6570\u636e\uff1a\u8def\u7531:{},appToken:{},userToken:{}", new Object[]{AppAuthContextHolder.getContext().getRequestInfo().getPath(), appToken, userToken});
        }
        if (!encrypt && dapEncrypt != null) {
            LOGGER.error("\u672a\u5904\u7406\u52a0\u5bc6\u6570\u636e\uff1a\u8def\u7531:{},appToken:{},userToken:{}", new Object[]{AppAuthContextHolder.getContext().getRequestInfo().getPath(), appToken, userToken});
        }
        List<Object> appSecretList = new ArrayList();
        if (dapSign != null || dapEncrypt != null) {
            appSecretList = this.dapSecretSupport.getEnableAppSecret(UserUtils.getToken(), appToken);
        }
        if (!sign && !encrypt) {
            filterChain.doFilter((ServletRequest)encryptRequestWrapper, (ServletResponse)response);
            return;
        }
        if (CollectionUtils.isEmpty(appSecretList)) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.APP_ID_SECRET_NONE, new Object[]{UserUtils.getSysId()});
        }
        if (StrUtils.isEmpty((String)UserUtils.getSysId())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.APP_ID_NONE);
        }
        String appSecret = null;
        if (sign) {
            try {
                DapSign signInfo = DapSign.get((String)signHeader);
                VerifyUtils.sign((DapSign)signInfo, () -> this.getLock(dapSign.resubmit(), signInfo.getNonce()));
                Map queryParams = ServletUtil.getParamMap((ServletRequest)request);
                String bodyParams = EncryptRequestFilter.getBodyParam(bodyString, method);
                boolean verified = false;
                for (String string : appSecretList) {
                    if (!SignUtils.verify((Map)JsonUtils.objToMap((Object)signInfo), (String)string, (Map)queryParams, (String)bodyParams)) continue;
                    verified = true;
                    appSecret = string;
                    request.setAttribute("appSecret", (Object)string);
                    break;
                }
                if (!verified) {
                    throw new UnauthorizedException((ErrorHandler)CommonErrorCode.SIGN_INCONSISTENT_SIGNATURE);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u9a8c\u7b7e\u5931\u8d25\uff1abody:{},enable secret list:{}", (Object)bodyString, (Object)JsonUtils.objToJson(appSecretList));
                throw new UnauthorizedException((ErrorHandler)CommonErrorCode.SIGN_INCONSISTENT_SIGNATURE, e.getMessage());
            }
        }
        if (StrUtils.isEmpty(appSecret)) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.APP_ID_SECRET_NONE, new Object[]{UserUtils.getSysId()});
        }
        if (encrypt) {
            DapEncrypt body = (DapEncrypt)JsonUtils.readValue((String)bodyString, DapEncrypt.class);
            String data = AES.decryptIvCBC((String)body.geteData(), appSecret);
            encryptRequestWrapper.setBodyString(data.getBytes(StandardCharsets.UTF_8));
        }
        filterChain.doFilter((ServletRequest)encryptRequestWrapper, (ServletResponse)response);
    }

    private boolean getLock(boolean resubmit, String nonce) {
        if (resubmit) {
            return true;
        }
        String key = String.format("%s:sign:nonce:%s", this.dapEnv.getAppName(), nonce);
        return RedisUtils.setIfAbsent((String)key, (Object)1, (Duration)Duration.ofMillis(600000L));
    }

    public int getOrder() {
        return FilterOrderEnum.API_ENCRYPT.order();
    }

    private boolean isSign(com.digiwin.dap.middle.encrypt.domain.annotation.DapSign dapSign, String signHeader) {
        if (dapSign == null) {
            return false;
        }
        if (Boolean.TRUE.equals(this.dapEnv.getSign()) || dapSign.force()) {
            return true;
        }
        return dapSign.request() && StrUtils.isNotEmpty((String)signHeader);
    }

    private boolean isEncrypt(HttpServletRequest request, com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt dapEncrypt, String bodyString) {
        DapEncrypt body;
        if (!bodyMethodList.contains(request.getMethod()) || dapEncrypt == null) {
            return false;
        }
        if (Boolean.TRUE.equals(this.dapEnv.getEncrypt()) || dapEncrypt.force()) {
            return true;
        }
        if (StrUtils.isEmpty((String)bodyString)) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.ENCRYPT_REQUEST_BODY_EMPTY);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bf7\u6c42\u53c2\u6570body\uff1a{}", (Object)bodyString);
        }
        return (body = (DapEncrypt)JsonUtils.readValue((String)bodyString, DapEncrypt.class)) != null && StrUtils.isNotEmpty((String)body.geteData());
    }
}

