package com.digiwin.dap.middle.encrypt.config;

import com.digiwin.dap.middle.encrypt.AnnotationUtil;
import com.digiwin.dap.middle.encrypt.constant.EncryptConstants;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.domain.StdDataEncrypt;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.servlet.http.HttpServletRequest;

/**
 * ResponseEntity类型 加密加签 响应处理
 * <p>
 *
 * @author fobgochod
 */
@ControllerAdvice
public class ResponseEntityEncryptResponse implements ResponseBodyAdvice<Object> {

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean hasAnnotation = AnnotationUtil.getAnnotation(returnType, DapEncrypt.class) != null
                || AnnotationUtil.getAnnotation(returnType, DapSign.class) != null;
        // 检查返回类型是否为 ResponseEntity 或其子类
        boolean isResponseTypeSupported = ResponseEntity.class.isAssignableFrom(returnType.getParameterType());
        return hasAnnotation && isResponseTypeSupported;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        HttpServletRequest req = ((ServletServerHttpRequest) request).getServletRequest();

        boolean encrypt = false;
        StdData result = StdData.ok(body);
        DapEncrypt dapEncrypt = AnnotationUtil.getAnnotation(returnType, DapEncrypt.class);
        if (dapEncrypt != null && dapEncrypt.response()) {
            String appSecret = (String) req.getAttribute(EncryptConstants.APP_SECRET_KEY);
            String dataString;
            if (BeanUtils.isSimpleProperty(body.getClass())) {
                dataString = body.toString();
            } else {
                dataString = JsonUtils.objToJson(body);
            }
            String eData = AES.encryptIvCBC(dataString, appSecret);
            result.setData(eData);
            encrypt = true;
        }

        DapSign dapSign = AnnotationUtil.getAnnotation(returnType, DapSign.class);
        if (dapSign != null && dapSign.response()) {
            StdDataEncrypt<Object> dataEncrypt = new StdDataEncrypt<>();
            dataEncrypt.setCode(result.getCode());
            dataEncrypt.setMessage(result.getMessage());
            dataEncrypt.setSuccess(result.getSuccess());
            dataEncrypt.setData(result.getData());

            String appSecret = (String) req.getAttribute(EncryptConstants.APP_SECRET_KEY);
            String dataString;
            if (BeanUtils.isSimpleProperty(result.getData().getClass())) {
                dataString = result.getData().toString();
            } else {
                dataString = SignUtils.sortParam(result.getData());
            }
            String sign = SignUtils.sign(appSecret, dataString);
            dataEncrypt.setSign(sign);
            result = dataEncrypt;
            encrypt = true;
        }
        return encrypt ? result : body;
    }
}