package com.digiwin.dap.middle.encrypt.constant;

import java.time.Duration;

public class EncryptConstants {

    public static final String AND = "&";
    public static final String EQUALS_SIGN = "=";

    // --------------------------------------------------------- sign start
    public static final int NONCE_MIN_LENGTH = 10;
    public static final int NONCE_MAX_LENGTH = 40;
    public static final long EXPIRE_TIME = 5 * 60 * 1_000L;
    /**
     * %s:sign:nonce:%s
     */
    public static final String REDIS_DWPAY_SIGN_NONCE = "%s:sign:nonce:%s";
    public static final String REDIS_APP_SECRET = "dap:encrypt:app:secret:%s";
    /** 可用的appsercet列表  */
    public static final String REDIS_ENABLE_APP_SECRET_LIST = "dap:encrypt:enable:app:secret:list:%s";

    public static final String APP_SECRET_KEY = "appSecret";
    public static final String SIGN_STATUS_KEY = "signStatus";
    public static final String ENCRYPT_STATUS_KEY = "encryptStatus";
    public static final Duration APP_SECRET_EXPIRE_TIME = Duration.ofHours(8L);
    public static final String MIDDLEWARE = "middleware";

    // --------------------------------------------------------- sign end
}
