/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.support;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.dap.middle.encrypt.domain.AppSecretVO;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

public class DefaultDapSecretSupport
implements DapSecretSupport {
    protected static final String APP_SECRET_CURRENT = "/api/iam/v2/dev/app/secret/current";
    protected static final String ENABLE_APP_SECRET_CURRENT = "/api/iam/v2/dev/app/enable/secret/current";
    protected static final String TENANT_SECRET_CURRENT = "/api/iam/v1/isv/credential/secret/current";
    private final DapEnv dapEnv;
    private final RestTemplate restTemplate;

    public DefaultDapSecretSupport(DapEnv dapEnv, RestTemplate restTemplate) {
        this.dapEnv = dapEnv;
        this.restTemplate = restTemplate;
    }

    @Override
    public String getAppSecret(String userToken, String appToken) {
        DecodedJWT jwt = JWT.decode((String)appToken);
        String id = jwt.getClaim("id").asString();
        String appSecretKey = String.format("dap:encrypt:app:secret:%s", id);
        String appSecret = (String)RedisUtils.get((Object)appSecretKey, String.class);
        if (ObjectUtils.isEmpty((Object)appSecret)) {
            String url = this.dapEnv.getIamUri() + APP_SECRET_CURRENT;
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            headers.add(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, appToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<AppSecretVO>>(){}, new Object[0]);
                StdData stdData = (StdData)responseEntity.getBody();
                if (stdData == null || !stdData.getSuccess().booleanValue()) {
                    return null;
                }
                return Optional.ofNullable(stdData.getData()).map(AppSecretVO::getAppSecret).orElse(null);
            }
            catch (Exception e) {
                throw new BusinessException(String.format("\u3010\u8c03\u7528IAM\u3011\u83b7\u53d6\u5e94\u7528[%s]appSecret\u5931\u8d25", UserUtils.getSysId()), (Throwable)e);
            }
        }
        return appSecret;
    }

    @Override
    public List<String> getEnableAppSecret(String userToken, String appToken) {
        DecodedJWT jwt = JWT.decode((String)appToken);
        String id = jwt.getClaim("id").asString();
        String appSecretKey = String.format("dap:encrypt:enable:app:secret:list:%s", id);
        String appSecretListStr = (String)RedisUtils.get((Object)appSecretKey, String.class);
        List<Map<String, String>> appSecretMapList = new ArrayList<Map<String, String>>();
        if (StringUtils.hasLength((String)appSecretListStr)) {
            appSecretMapList = (List)JsonUtils.jsonToObj((String)appSecretListStr, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        }
        if (CollectionUtils.isEmpty(appSecretMapList)) {
            String url = this.dapEnv.getIamUri() + ENABLE_APP_SECRET_CURRENT;
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            headers.add(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, appToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<AppSecretVO>>(){}, new Object[0]);
                StdData stdData = (StdData)responseEntity.getBody();
                if (stdData == null || !stdData.getSuccess().booleanValue()) {
                    return null;
                }
                appSecretMapList = Optional.ofNullable(stdData.getData()).map(AppSecretVO::getAppSecretList).orElse(null);
            }
            catch (Exception e) {
                throw new BusinessException(String.format("\u3010\u8c03\u7528IAM\u3011\u83b7\u53d6\u5e94\u7528[%s]appSecret\u5931\u8d25", UserUtils.getSysId()), (Throwable)e);
            }
        }
        return this.filterExpireAppSecret(appSecretMapList);
    }

    @Override
    public String getDevSecret(String userToken, String devKey) {
        String url = this.dapEnv.getIamUri() + TENANT_SECRET_CURRENT;
        try {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("devKey", devKey);
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<AppSecretVO>>(){}, new Object[0]);
            return ((AppSecretVO)((StdData)responseEntity.getBody()).getData()).getAppSecret();
        }
        catch (Exception e) {
            throw new BusinessException(String.format("\u3010\u8c03\u7528IAM\u3011\u83b7\u53d6\u79df\u6237[%s]devSecret\u5931\u8d25", UserUtils.getTenantId()), (Throwable)e);
        }
    }

    private List<String> filterExpireAppSecret(List<Map<String, String>> appSecretMapList) {
        if (CollectionUtils.isEmpty(appSecretMapList)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map<String, String> appSecretMap : appSecretMapList) {
            String expireTime = appSecretMap.get("expireTime");
            if (StringUtils.hasLength((String)expireTime) && !LocalDateTime.now().isBefore(LocalDateTime.parse(expireTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))) continue;
            result.add(appSecretMap.get("appSecret"));
        }
        return result;
    }
}

