package com.digiwin.dap.middle.encrypt;

import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import java.lang.annotation.Annotation;

public class AnnotationUtil {

    public static <T extends Annotation> T getAnnotation(MethodParameter returnType, Class<T> annotationType) {
        T annotation = AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), annotationType);
        if (annotation == null) {
            return returnType.getMethodAnnotation(annotationType);
        }
        return annotation;
    }

    public static <T extends Annotation> T getAnnotation(HandlerMethod handlerMethod, Class<T> annotationType) {
        T annotation = AnnotationUtils.findAnnotation(handlerMethod.getBeanType(), annotationType);
        if (annotation == null) {
            return handlerMethod.getMethodAnnotation(annotationType);
        }
        return annotation;
    }
}
