package com.digiwin.dap.middle.encrypt.api;

import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * 加密加签测试
 *
 * @author fobgochod
 * @date 2019/4/18
 */
@RestController
@RequestMapping("/api/${spring.application.name}/v2/encrypt")
public class EncryptController {

    @Autowired
    private DapEnv dapEnv;

    /**
     * 加密加签-返回null
     */
    @DapEncrypt
    @DapSign(resubmit = true)
    @GetMapping("/test1")
    public ResponseEntity<?> test1() {
        return ResponseEntity.ok(null);
    }

    /**
     * 加密加签-返回null
     */
    @DapEncrypt
    @DapSign(resubmit = true)
    @GetMapping("/dap/test1")
    public StdData<?> dapTest1() {
        return StdData.ok(null);
    }

    /**
     * 加密加签-返回普通对象
     */
    @DapEncrypt
    @DapSign(resubmit = true)
    @PostMapping("/test2")
    public ResponseEntity<?> test2(@RequestBody ReqBody body) {
        return ResponseEntity.ok(body);
    }

    /**
     * 加密加签-返回普通对象
     */
    @DapEncrypt
    @DapSign(resubmit = true)
    @PostMapping("/dap/test2")
    public StdData<?> dapTest2(@RequestBody ReqBody body) {
        return StdData.ok(body);
    }

    /**
     * 根据是否传递请求头决定是否加密加签，响应不加密加签
     */
    @DapEncrypt(force = false)
    @DapSign(force = false, resubmit = true)
    @PostMapping("/test3")
    public ResponseEntity<?> test3(@RequestBody ReqBody body) {
        return ResponseEntity.ok(body);
    }

    /**
     * 根据是否传递请求头决定是否加密加签，响应不加密加签
     */
    @DapEncrypt(force = false)
    @DapSign(force = false, resubmit = true)
    @PostMapping("/dap/test3")
    public StdData<?> dapTest3(@RequestBody ReqBody body) {
        return StdData.ok(body);
    }

    /**
     * 根据是否传递请求头决定是否加签，响应不加签
     */
    @DapSign(force = false, resubmit = true)
    @PostMapping("/test4")
    public ResponseEntity<?> test4(@RequestBody ReqBody body) {
        return ResponseEntity.ok(body);
    }

    /**
     * 根据是否传递请求头决定是否加签，响应不加签
     */
    @DapSign(force = false, resubmit = true)
    @PostMapping("/dap/test4")
    public StdData<?> dapTest4(@RequestBody ReqBody body) {
        return StdData.ok(body);
    }

    /**
     * 请求不加签，响应加签
     */
    @DapSign(force = false, request = false, response = true, resubmit = true)
    @PostMapping("/test5")
    public ResponseEntity<?> test5(@RequestBody ReqBody body) {
        return ResponseEntity.ok(body);
    }

    /**
     * 请求不加签，响应加签
     */
    @DapSign(force = false, request = false, response = true, resubmit = true)
    @PostMapping("/dap/test5")
    public StdData<?> dapTest5(@RequestBody ReqBody body) {
        return StdData.ok(body);
    }

    /**
     * 请求兼容加密和不加密
     */
    @DapEncrypt(force = false)
    @PostMapping("/test6")
    public ResponseEntity<?> test6(@RequestBody ReqBody body) {
        return ResponseEntity.ok(body);
    }

    /**
     * 请求兼容加密和不加密
     */
    @DapEncrypt(force = false)
    @PostMapping("/dap/test6")
    public StdData<?> dapTest6(@RequestBody ReqBody body) {
        return StdData.ok(body);
    }

    /**
     * 请求响应都加密
     */
    @DapEncrypt(response = true)
    @PostMapping("/test7")
    public ResponseEntity<?> test7(@RequestBody ReqBody body) {
        return ResponseEntity.ok(body);
    }

    /**
     * 请求响应都加密
     */
    @DapEncrypt(response = true)
    @PostMapping("/dap/test7")
    public StdData<?> dapTest7(@RequestBody ReqBody body) {
        return StdData.ok(body);
    }

    /**
     * {"id":"test","name":"测试"}
     */
    public static class ReqBody {
        private String id;
        private String name;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}
