/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway;

import com.digiwin.dap.middle.gateway.GatewayExecutorConfiguration;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.web.HttpTrackFilter;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ComponentScan(basePackages={"com.digiwin.dap.middle.gateway"})
@Configuration
@Import(value={GatewayExecutorConfiguration.class})
@ConditionalOnProperty(name={"dap.middleware.access-log"}, havingValue="true")
public class GatewayConfiguration {
    @Autowired
    private DapEnv dapEnv;

    @Bean(name={"gwLmcClient"})
    public LMC gwLmcClient() {
        return new LMCClient(this.dapEnv.getLmcUri(), "crstatscenter", this.dapEnv.getAppToken(), this.dapEnv.getAppSecret());
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpTrackFilter"})
    public FilterRegistrationBean<Filter> httpTrackFilter(HttpTrackRepository repository) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        HttpTrackFilter filter = new HttpTrackFilter(repository);
        registrationBean.setFilter((Filter)filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(new String[]{"/api/*"});
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}

