/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.track;

import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LmcHttpTrackService {
    private static final Logger logger = LoggerFactory.getLogger(LmcHttpTrackService.class);
    @Autowired
    private DapEnv dapEnv;
    @Autowired
    private LMC gwLmcClient;

    public void save(List<HttpTrack> tracks) {
        if (tracks == null || tracks.isEmpty()) {
            return;
        }
        ArrayList<SaveEventLog> eventLogs = new ArrayList<SaveEventLog>();
        for (HttpTrack track : tracks) {
            HttpTrack.Request request;
            SaveEventLog eventLog = new SaveEventLog();
            eventLog.setAppId("crstatscenter");
            eventLog.setEventSource(this.dapEnv.getAppName());
            eventLog.setStatus(Integer.valueOf(HttpStatus.valueOf((int)track.getResponse().getStatus()).is2xxSuccessful() ? 0 : 1));
            eventLog.setEventType(Integer.valueOf(11));
            eventLog.setEventId("SERVICE_CALL");
            eventLog.setEventName("\u670d\u52a1\u8c03\u7528");
            if (track.getUser() != null) {
                eventLog.setUserId(track.getUser().getUserId());
                eventLog.setUserName(track.getUser().getUserName());
                eventLog.setTenantId(track.getUser().getTenantId());
                eventLog.setTenantName(track.getUser().getTenantName());
            }
            if (track.getSys() != null) {
                eventLog.setSysId(track.getSys().getId());
            }
            if (StringUtils.isEmpty((Object)eventLog.getTenantId())) {
                eventLog.setTenantId("unknown");
            }
            if (StringUtils.isEmpty((Object)eventLog.getSysId())) {
                eventLog.setSysId("unknown");
            }
            if ((request = track.getRequest()) != null) {
                eventLog.setMethod(request.getMethod());
                eventLog.setRequestUrl(request.getUri().getPath());
                LinkedHashMap<String, Object> contents = new LinkedHashMap<String, Object>();
                ZonedDateTime invokeTime = track.getTimestamp().atZone(ZoneOffset.systemDefault());
                contents.put("invokeTime", invokeTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
                contents.put("method", request.getMethod());
                contents.put("uri", request.getUri());
                contents.put("headers", new HashMap<String, String>(request.getHeaders()));
                contents.put("remoteAddress", request.getRemoteAddress());
                contents.put("timeTaken", track.getTimeTaken());
                eventLog.setContent(contents);
            }
            eventLogs.add(eventLog);
        }
        try {
            this.gwLmcClient.saveEventLogBatch(eventLogs);
            logger.debug("Http\u8bbf\u95ee\u8bb0\u5f55\u5165\u5e93\uff1a\u6210\u529f\u5904\u7406[{}]\u6761\u6570\u636e", (Object)tracks.size());
        }
        catch (Exception e) {
            logger.error("\u8bb0\u5f55\u8bbf\u95ee\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
        }
    }
}

