/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.track.http;

import com.digiwin.dap.middle.gateway.service.track.http.TraceableRequest;
import com.digiwin.dap.middle.gateway.service.track.http.TraceableResponse;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.util.TokenUtils;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;

public class HttpTrack
implements InitializingBean {
    private final Instant timestamp;
    private final Request request;
    private volatile Response response;
    private volatile Long timeTaken;
    private volatile AuthoredUser user;
    private volatile AuthoredSys sys;

    public HttpTrack(TraceableRequest request) {
        this.request = new Request(request);
        this.timestamp = Instant.now();
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Long getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(Long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public AuthoredUser getUser() {
        return this.user;
    }

    public void setUser(AuthoredUser user) {
        this.user = user;
    }

    public AuthoredSys getSys() {
        return this.sys;
    }

    public void setSys(AuthoredSys sys) {
        this.sys = sys;
    }

    public void afterPropertiesSet() {
        try {
            AuthoredSys authoredSys;
            this.timeTaken = System.currentTimeMillis() - this.timestamp.toEpochMilli();
            AuthoredUser authoredUser = TokenUtils.getAuthoredUser();
            if (authoredUser != null) {
                this.user = new AuthoredUser();
                BeanUtils.copyProperties((Object)authoredUser, (Object)this.user);
            }
            if ((authoredSys = TokenUtils.getAuthoredSys()) != null) {
                this.sys = new AuthoredSys();
                BeanUtils.copyProperties((Object)authoredSys, (Object)this.sys);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Response {
        private final int status;
        private final Map<String, String> headers;

        public Response(TraceableResponse response, int status) {
            this.status = status;
            this.headers = response.getHeaders();
        }

        public int getStatus() {
            return this.status;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    public static final class Request {
        private final String method;
        private final URI uri;
        private final Map<String, String> headers;
        private final String remoteAddress;

        private Request(TraceableRequest request) {
            this.method = request.getMethod();
            this.uri = request.getUri();
            this.headers = request.getHeaders();
            this.remoteAddress = request.getRemoteAddress();
        }

        public String getMethod() {
            return this.method;
        }

        public URI getUri() {
            return this.uri;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }
    }
}

