/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.track.web;

import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.web.TraceableHttpServletRequest;
import com.digiwin.dap.middle.gateway.service.track.web.TraceableHttpServletResponse;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpTrackFilter
extends OncePerRequestFilter
implements Ordered {
    private final HttpTrackRepository repository;

    public HttpTrackFilter(HttpTrackRepository repository) {
        this.repository = repository;
    }

    public int getOrder() {
        return FilterOrderEnum.ACCESS_LOG.order();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.isRequestValid(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        TraceableHttpServletRequest traceableRequest = new TraceableHttpServletRequest(request);
        HttpTrack track = new HttpTrack(traceableRequest);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            status = response.getStatus();
        }
        finally {
            TraceableHttpServletResponse traceableResponse = new TraceableHttpServletResponse(response);
            track.afterPropertiesSet();
            track.setResponse(new HttpTrack.Response(traceableResponse, status));
            this.repository.add(track);
        }
    }

    private boolean isRequestValid(HttpServletRequest request) {
        try {
            new URI(request.getRequestURL().toString());
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }
}

