/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.track.web;

import com.digiwin.dap.middle.gateway.service.track.http.TraceableRequest;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

final class TraceableHttpServletRequest
implements TraceableRequest {
    private final HttpServletRequest request;

    TraceableHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public URI getUri() {
        String queryString = this.request.getQueryString();
        if (!StringUtils.hasText((String)queryString)) {
            return URI.create(this.request.getRequestURL().toString());
        }
        try {
            StringBuffer urlBuffer = this.appendQueryString(queryString);
            return new URI(urlBuffer.toString());
        }
        catch (URISyntaxException ex) {
            String encoded = UriUtils.encodeQuery((String)queryString, (Charset)StandardCharsets.UTF_8);
            StringBuffer urlBuffer = this.appendQueryString(encoded);
            return URI.create(urlBuffer.toString());
        }
    }

    private StringBuffer appendQueryString(String queryString) {
        return this.request.getRequestURL().append("?").append(queryString);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.extractHeaders();
    }

    @Override
    public String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    private Map<String, String> extractHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!DapHttpHeaders.contains((String)name)) continue;
            headers.put(name, this.request.getHeader(name));
        }
        return headers;
    }
}

