package com.digiwin.dap.middle.gateway.service.log;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Component
public class DapLoggingInterceptorConfigurer implements BeanPostProcessor {

    @Autowired
    private DapLoggingInterceptor dapLoggingInterceptor;

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestTemplate) {
            RestTemplate restTemplate = (RestTemplate) bean;
            List<ClientHttpRequestInterceptor> interceptors = restTemplate.getInterceptors();
            interceptors.add(dapLoggingInterceptor);
            restTemplate.setInterceptors(interceptors);
        }
        return bean;
    }
}
