/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.log;

import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class DapLoggingInterceptor
implements ClientHttpRequestInterceptor,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DapLoggingInterceptor.class);
    @Autowired
    private DapEnv dapEnv;
    private LMC lmcClient;

    public void afterPropertiesSet() throws Exception {
        this.lmcClient = new LMCClient(this.dapEnv.getLmcUri(), this.dapEnv.getAppName(), this.dapEnv.getAppToken(), this.dapEnv.getAppSecret());
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            return execution.execute(request, body);
        }
        catch (IOException e) {
            this.logRequestEx(request, body, e);
            throw e;
        }
    }

    public void logRequestEx(HttpRequest request, byte[] body, IOException e) {
        try {
            SaveEventLog eventLog = new SaveEventLog();
            eventLog.setAppId("coremiddleware");
            eventLog.setEventSource(this.dapEnv.getAppName());
            eventLog.setEventType(Integer.valueOf(99));
            eventLog.setEventId("INTERNAL_SERVICE_CALL");
            eventLog.setEventName("\u5185\u90e8\u670d\u52a1\u8c03\u7528");
            eventLog.setUserId(UserUtils.getUserId());
            eventLog.setUserName(UserUtils.getUserName());
            eventLog.setTenantId(UserUtils.getTenantId());
            eventLog.setTenantName(UserUtils.getTenantName());
            eventLog.setSysId(UserUtils.getSysId());
            eventLog.setStatus(Integer.valueOf(1));
            eventLog.setErrorMsg(e.getMessage());
            eventLog.setMethod(request.getMethodValue());
            eventLog.setRequestUrl(request.getURI().getPath());
            eventLog.setRequestParam(request.getURI().getQuery());
            LinkedHashMap<String, Object> contents = new LinkedHashMap<String, Object>();
            contents.put("uri", request.getURI());
            contents.put("method", request.getMethod());
            contents.put("headers", this.extractHeaders(request));
            contents.put("requestBody", new String(body, StandardCharsets.UTF_8));
            eventLog.setContent(contents);
            this.lmcClient.saveEventLog(eventLog);
        }
        catch (Exception ex) {
            logger.error("\u8bb0\u5f55\u5185\u90e8\u8c03\u7528\u5f02\u5e38", (Throwable)ex);
        }
    }

    private Map<String, String> extractHeaders(HttpRequest request) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        request.getHeaders().forEach((key, value) -> {
            if (DapHttpHeaders.contains((String)key)) {
                headers.put((String)key, (String)value.get(0));
            }
        });
        return headers;
    }
}

