/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.stats.filter;

import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpStatsFilter
extends OncePerRequestFilter
implements Ordered {
    private static final String EMPTY_SYS = "empty";
    private static final String STATS_SYS_PREFIX = ":stats:sys:";
    private final String appName;

    public HttpStatsFilter(String appName) {
        this.appName = appName;
    }

    private static void setExpire(String key) {
        Long expire = RedisUtils.getExpire((String)key);
        if (expire == null || expire == -1L) {
            RedisUtils.expire((String)key, (long)7L, (TimeUnit)TimeUnit.DAYS);
        }
    }

    public int getOrder() {
        return FilterOrderEnum.API_STATS.order();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        AppAuthContext context = AppAuthContextHolder.getContext();
        RequestInfo requestInfo = context.getRequestInfo();
        try {
            requestInfo.setM(request.getMethod());
            requestInfo.setP(request.getRequestURI());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable throwable) {
            String sysId = context.getAuthoredSys() == null ? EMPTY_SYS : context.getAuthoredSys().getId();
            String today = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
            String key = this.appName + STATS_SYS_PREFIX + today + ":" + response.getStatus() + ":" + requestInfo.getM() + "-" + requestInfo.getP();
            RedisUtils.opsForHash().increment((Object)key, (Object)sysId, 1L);
            throw throwable;
        }
        String sysId = context.getAuthoredSys() == null ? EMPTY_SYS : context.getAuthoredSys().getId();
        String today = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String key = this.appName + STATS_SYS_PREFIX + today + ":" + response.getStatus() + ":" + requestInfo.getM() + "-" + requestInfo.getP();
        RedisUtils.opsForHash().increment((Object)key, (Object)sysId, 1L);
    }
}

