package com.digiwin.dap.middle.gateway;

import com.digiwin.dap.middle.gateway.constant.GatewayConstants;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.web.HttpTrackFilter;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;

import javax.servlet.Filter;

@AutoConfiguration
@ComponentScan(basePackages = "com.digiwin.dap.middle.gateway")
@ConditionalOnProperty(name = "dap.middleware.access-log", havingValue = "true")
@Import(GatewayExecutorConfiguration.class)
public class GatewayConfiguration {

    @Autowired
    private DapEnv dapEnv;
    @Value("${dap.middleware.lmc.svc.uri:}")
    private String lmcSvcUri;

    @Bean(name = "gwLmcClient")
    public LMC gwLmcClient() {
        return new LMCClient(lmcSvcUri, GatewayConstants.HTTP_TRACK_CR_STATS_CENTER, dapEnv.getAppToken(), dapEnv.getAppSecret());
    }

    /**
     * 拦截访问日志参数
     */
    @Bean
    @ConditionalOnMissingBean(name = "httpTrackFilter")
    public FilterRegistrationBean<Filter> httpTrackFilter(HttpTrackRepository repository) {
        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        final HttpTrackFilter filter = new HttpTrackFilter(repository);
        registrationBean.setFilter(filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns("/api/*");
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}
