package com.digiwin.dap.middle.gateway.service.schedule.impl;

import com.digiwin.dap.middle.gateway.constant.GatewayConstants;
import com.digiwin.dap.middle.gateway.service.schedule.TaskService;
import com.digiwin.dap.middle.gateway.service.track.LmcHttpTrackService;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Redis切换服务
 *
 * @author fobgochod
 * @date 2021/2/2
 */
@Service
public class HttpTrackTaskService implements TaskService {

    private static final Logger logger = LoggerFactory.getLogger(HttpTrackTaskService.class);

    @Autowired
    private HttpTrackRepository httpTrackRepository;
    @Autowired
    private LmcHttpTrackService lmcHttpTrackService;

    @Scheduled(fixedRate = GatewayConstants.HTTP_TRACK_EXECUTE_FIXED_PERIOD)
    @Override
    public void httpTrack() {
        try {
            List<HttpTrack> tracks = httpTrackRepository.getAll();
            lmcHttpTrackService.save(tracks);
        } catch (Exception e) {
            logger.error("Http访问记录统计异常：{}", e.getMessage());
        }
    }
}
