package com.digiwin.dap.middle.gateway.service.track.web;

import com.digiwin.dap.middle.gateway.service.track.http.TraceableRequest;
import com.digiwin.dap.middleware.util.HttpUtils;

import javax.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Map;

/**
 * An adapter that exposes an {@link HttpServletRequest} as a {@link TraceableRequest}.
 *
 * @author fobgochod
 * @date 2022/11/17 14:51
 */
final class TraceableHttpServletRequest implements TraceableRequest {

    private final HttpServletRequest request;
    private final HttpUtils httpUtils;

    TraceableHttpServletRequest(HttpServletRequest request) {
        this.request = request;
        this.httpUtils = HttpUtils.build(request);
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public URI getUri() {
        return httpUtils.getUri();
    }

    @Override
    public Map<String, String> getHeaders() {
        return httpUtils.getHeaders();
    }

    @Override
    public String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }
}
