/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.track.http;

import com.digiwin.dap.middle.gateway.service.track.LmcHttpTrackService;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class InMemoryHttpTrackRepository
implements HttpTrackRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryHttpTrackRepository.class);
    private final List<HttpTrack> traces = new LinkedList<HttpTrack>();
    @Autowired
    private LmcHttpTrackService lmcHttpTrackService;
    @Qualifier(value="httpTrackExecutor")
    @Autowired
    private ThreadPoolTaskExecutor httpTrackExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpTrack> findAll() {
        List<HttpTrack> list = this.traces;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<HttpTrack>(this.traces));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(HttpTrack trace) {
        List<HttpTrack> list = this.traces;
        synchronized (list) {
            if (this.traces.size() >= 100) {
                try {
                    ArrayList<HttpTrack> httpTracks = new ArrayList<HttpTrack>(this.traces);
                    this.httpTrackExecutor.execute(() -> this.lmcHttpTrackService.save(httpTracks));
                    this.traces.clear();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            this.traces.add(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpTrack> getAll() {
        List<HttpTrack> list = this.traces;
        synchronized (list) {
            ArrayList<HttpTrack> httpTracks = new ArrayList<HttpTrack>(this.traces);
            this.traces.clear();
            return httpTracks;
        }
    }
}

