package com.digiwin.dap.middle.ha.service;

import com.digiwin.dap.middle.ha.config.RedisHealthProperties;
import com.digiwin.dap.middle.ha.domain.Redis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 缓存db切换服务
 *
 * @author linli  2020/10/30
 */
@Service
public class RedisConfigService implements InitializingBean {

    private static final Logger logger = LoggerFactory.getLogger(RedisConfigService.class);

    private Redis master;
    private Redis replica;

    @Autowired
    private RedisHealthProperties env;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean changeHost(Redis redis) {
        JedisConnectionFactory redisFactory = (JedisConnectionFactory) redisTemplate.getConnectionFactory();
        if (redisFactory == null) return Boolean.FALSE;
        RedisStandaloneConfiguration standaloneConfig = redisFactory.getStandaloneConfiguration();
        if (standaloneConfig == null) return Boolean.FALSE;
        Redis run = Redis.of(redisFactory.getHostName(), redisFactory.getPort());
        try {
            if (!redis.equals(run)) {
                // 关闭连接池
                redisFactory.destroy();
                // 设置信息
                standaloneConfig.setHostName(redis.getHost());
                standaloneConfig.setPort(redis.getPort());
                standaloneConfig.setPassword(redis.getPassword());
                standaloneConfig.setDatabase(redis.getDatabase());
                redisFactory.afterPropertiesSet();
                redisTemplate.setConnectionFactory(redisFactory);
                // 是否可用
                redisTemplate.execute(RedisConnectionCommands::ping);
            }
            return Boolean.TRUE;
        } catch (Exception e) {
            logger.error("Redis[{}]切换失败，错误信息{}", redis, e.getMessage());
            redisFactory.destroy();
            standaloneConfig.setHostName(run.getHost());
            standaloneConfig.setPort(run.getPort());
            standaloneConfig.setPassword(run.getPassword());
            standaloneConfig.setDatabase(run.getDatabase());
            redisFactory.afterPropertiesSet();
            redisTemplate.setConnectionFactory(redisFactory);
        }
        return Boolean.FALSE;
    }

    public boolean isMasterRedis() {
        try {
            JedisConnectionFactory redisFactory = (JedisConnectionFactory) redisTemplate.getConnectionFactory();
            Redis run = Redis.of(Objects.requireNonNull(redisFactory).getHostName(), redisFactory.getPort());
            return run.equals(this.master);
        } catch (Exception ignored) {
        }
        return Boolean.FALSE;
    }

    public RedisStandaloneConfiguration getReplicaConfig() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(replica.getHost());
        config.setPort(replica.getPort());
        config.setPassword(RedisPassword.of(replica.getPassword()));
        config.setDatabase(replica.getDatabase());
        return config;
    }

    public Redis master() {
        return master;
    }

    public Redis replica() {
        return replica;
    }

    @Override
    public void afterPropertiesSet() {
        this.master = Redis.of(env.getRedisHost(), env.getRedisPort(), env.getRedisDb(), env.getRedisPassword());
        this.replica = Redis.of(env.getRedis2Host(), env.getRedis2Port(), env.getRedis2Db(), env.getRedis2Password());
    }
}
