//package com.digiwin.dap.middle.kms.service;
//
//import com.digiwin.dap.middle.kms.constants.KeyConstant;
//import com.digiwin.dap.middle.kms.utils.PemUtils;
//import com.digiwin.dap.middleware.commons.crypto.constant.AlgorithmEnum;
//import org.springframework.boot.CommandLineRunner;
//
//import java.util.*;
//import java.util.concurrent.ConcurrentHashMap;
//
///**
// * @author michael
// */
//public abstract class AbstractKmsService implements KmsService, CommandLineRunner {
//
//    public static final String FILE_EXTENSION = ".pem";
//    public static final String PEM_FILE_TYPE = "DAP %s KEY";
//
//    private Map<String, String> keyMap = new ConcurrentHashMap<>();
//
//    private Map<String, AlgorithmEnum> algorithmMap;
//
//    public AbstractKmsService(Map<String, AlgorithmEnum> algorithmMap) {
//        this.algorithmMap = algorithmMap;
//    }
//
//    @Override
//    public String findKey(String fileName) {
//        if (!keyMap.containsKey(fileName)) {
//            throw new IllegalArgumentException("Key not found: " + fileName);
//        }
//        return keyMap.get(fileName);
//    }
//
//    @Override
//    public void registerKey(String key, String fileName, AlgorithmEnum algorithmEnum) {
//        if (keyMap.containsKey(key)) {
//            throw new IllegalArgumentException("fileName" + fileName + " already exists");
//        }
//        if (!fileName.endsWith(FILE_EXTENSION)) {
//            fileName = fileName + FILE_EXTENSION;
//        }
//        String type = String.format(PEM_FILE_TYPE, algorithmEnum.getValue().toUpperCase());
//        PemUtils.writeKeyToPemFile(key, type, fileName, algorithmEnum);
//        keyMap.put(fileName, key);
//    }
//
//    @Override
//    public void run(String... args) {
//        // 内置密钥
//        algorithmMap.put(KeyConstant.IV_STR, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.CAS, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.CONSOLE, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.DIGIWIN, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.LOGIN, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.LOGIN_AGENT, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.OTHER, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.TEMP_TOKEN_SECRET, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.WECHAT_UNION_ID, AlgorithmEnum.AES);
//        algorithmMap.put(KeyConstant.BASE64_PRIVATE_KEY, AlgorithmEnum.RSA);
//        algorithmMap.put(KeyConstant.BASE64_PUBLIC_KEY, AlgorithmEnum.RSA);
//
//        for (Map.Entry<String, AlgorithmEnum> entry : algorithmMap.entrySet()) {
//            if (Objects.isNull(entry.getKey())) {
//                continue;
//            }
//            String key = PemUtils.readKeyFromPemFile(entry.getKey(), entry.getValue());
//            keyMap.put(entry.getKey(), key);
//        }
//    }
//}
