package com.digiwin.dap.middleware.language.entity;

import com.digiwin.dap.middleware.entity.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 默认多语言数据表
 *
 * @author chenzhuang
 * @date 2023-2-14 17:39:27
 */
@Entity
@Table(name = "multi_language_default")
public class LanguageDefault extends BaseEntity {
    /** 字段名 */
    @Column(name = "field_name", columnDefinition = "varchar(40) NOT NULL COMMENT '字段名称'")
    private String fieldName;
    /** 多语言：zh-CN;zh-TW;en-US 等 */
    @Column(name = "language", columnDefinition = "varchar(40) NOT NULL COMMENT '语言别'")
    private String language;
    /** 数据id */
    @Column(name = "data_id", columnDefinition = "varchar(100) NOT NULL COMMENT '数据id'")
    private String dataId;
    /** 内容 */
    @Column(name = "content", columnDefinition = "text COMMENT '内容'")
    private String content;

    public LanguageDefault() {
    }

    public LanguageDefault(String fieldName, String language, String dataId, String content) {
        this.fieldName = fieldName;
        this.language = language;
        this.dataId = dataId;
        this.content = content;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDataId() {
        return dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
