package com.digiwin.dap.middleware.language.service;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * The interface Language service.
 */
public interface LanguageService {
    /**
     * 对象多语言转换
     *
     * @param target     需要做多语言的对象
     * @param targetType 对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target     需要做多语言的对象
     * @param targetType 对象类型
     * @param entityType 默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target     需要做多语言的对象
     * @param dataSid    对象主键，用于查询对象设定的多语言信息
     * @param targetType 对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, long dataSid, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target     需要做多语言的对象
     * @param dataSid    对象主键，用于查询对象设定的多语言信息
     * @param targetType 对象类型
     * @param entityType 默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, long dataSid, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param targetType  对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, String primaryName, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, String primaryName, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param dataSid     对象主键，用于查询对象设定的多语言信息
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, long dataSid, String languageTag, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param dataSid     对象主键，用于查询对象设定的多语言信息
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, long dataSid, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, String primaryName, String languageTag, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, String primaryName, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param targetType  对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, String primaryName, Map<String, String> fieldMap, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, String primaryName, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target     需要做多语言的对象
     * @param dataSid    对象主键，用于查询对象设定的多语言信息
     * @param fieldMap   对象属性->多语言字段，两者不一致需要传递
     * @param targetType 对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, long dataSid, Map<String, String> fieldMap, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target     需要做多语言的对象
     * @param dataSid    对象主键，用于查询对象设定的多语言信息
     * @param fieldMap   对象属性->多语言字段，两者不一致需要传递
     * @param targetType 对象类型
     * @param entityType 默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, long dataSid, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param dataSid     对象主键，用于查询对象设定的多语言信息
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, long dataSid, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @return 多语言处理后的目标对象 t
     */
    <T> T parse(T target, String primaryName, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param primaryName 对象主键名称，用于查询对象设定的多语言信息
     * @param idName      对象主键名称，用于查询对象的默认多语言信息
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, String primaryName, String idName, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * 对象多语言转换
     *
     * @param target      需要做多语言的对象
     * @param dataSid     对象主键，用于查询对象设定的多语言信息
     * @param idValue     对象id值，用于查询对象的默认多语言信息
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return 多语言处理后的目标对象 t
     */
    <T, K> T parse(T target, long dataSid, String idValue, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType);


    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param targetType 对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param targetType 对象类型
     * @param entityType 默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param fieldMap   对象属性->多语言字段，两者不一致需要传递
     * @param targetType 对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, Map<String, String> fieldMap, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param fieldMap   对象属性->多语言字段，两者不一致需要传递
     * @param targetType 对象类型
     * @param entityType 默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, String primaryName, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, String primaryName, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param locale     the locale
     * @param targetType 对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, Locale locale, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param locale     the locale
     * @param targetType 对象类型
     * @param entityType 默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, Locale locale, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, String primaryName, Map<String, String> fieldMap, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, String primaryName, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, String primaryName, String languageTag, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, String primaryName, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets    需要做多语言的对象集合
     * @param dataSids   对象主键集合，大小应该和targets.size()一样
     * @param fieldMap   对象属性->多语言字段，两者不一致需要传递
     * @param targetType 对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, List<Long> dataSids, Map<String, String> fieldMap, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param dataSids    对象主键集合，大小应该和targets.size()一样
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, String primaryName, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param dataSids    对象主键集合，大小应该和targets.size()一样
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, String primaryName, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets      需要做多语言的对象集合
     * @param primaryField the primary field
     * @param dataSids     对象主键集合，大小应该和targets.size()一样
     * @param fieldMap     对象属性->多语言字段，两者不一致需要传递
     * @param languageTag  要转换的多语言tag
     * @param targetType   对象类型
     * @return the list
     */
    <T> List<T> parse(List<T> targets, Field primaryField, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param idName      对象存放id的字段名称，一般是id
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, String primaryName, String idName, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets     需要做多语言的对象集合
     * @param primaryName 对象存放主键的字段名称，一般是sid
     * @param idName      对象存放id的字段名称，一般是id
     * @param dataSids    对象主键集合，大小应该和targets.size()一样
     * @param fieldMap    对象属性->多语言字段，两者不一致需要传递
     * @param languageTag 要转换的多语言tag
     * @param targetType  对象类型
     * @param entityType  默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, String primaryName, String idName, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType);

    /**
     * list多语言转换
     *
     * @param targets      需要做多语言的对象集合
     * @param primaryField 对象存放主键的字段，一般是sid
     * @param idField      对象存放id的字段，一般是id
     * @param dataSids     对象主键集合，大小应该和targets.size()一样
     * @param fieldMap     对象属性->多语言字段，两者不一致需要传递
     * @param languageTag  要转换的多语言tag
     * @param targetType   对象类型
     * @param entityType   默认多语言类型
     * @return the list
     */
    <T, K> List<T> parse(List<T> targets, Field primaryField, Field idField, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType);
}
