/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.license.utils;

import com.digiwin.dap.middle.license.utils.SystemArch;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class NativeUtils {
    public static final String NATIVE_FOLDER_PATH_PREFIX = "native";
    private static File temporaryDir;

    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load(String libName) {
        try {
            String libExtension = SystemArch.getExt();
            String libFilename = libName + libExtension;
            File tempFile = NativeUtils.createTempFile(libFilename);
            try {
                System.load(tempFile.getAbsolutePath());
            }
            finally {
                tempFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load library: " + libName, e);
        }
    }

    public static synchronized void load0(String libFilename) {
        try {
            File tempFile = NativeUtils.createTempFile(libFilename);
            try {
                System.load(tempFile.getAbsolutePath());
            }
            finally {
                tempFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load library: " + libFilename, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Library> T loadLibrary(String libName, Class<T> interfaceClass) {
        try {
            String libExtension = SystemArch.getExt();
            String libFilename = libName + libExtension;
            File tempFile = NativeUtils.createTempFile(libFilename);
            try {
                Library library = Native.load((String)tempFile.getAbsolutePath(), interfaceClass);
                return (T)library;
            }
            finally {
                tempFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load library: " + libName, e);
        }
    }

    private static File createTempDirectory() throws IOException {
        String tempDir = "target/native";
        File temp = new File(tempDir);
        if (temp.exists()) {
            return temp;
        }
        if (temp.mkdirs()) {
            temp.setWritable(true, false);
            temp.setExecutable(true, false);
            temp.setReadable(true, false);
            return temp;
        }
        throw new IOException("Failed to create temp directory " + temp.getName());
    }

    private static File createTempFile(String libName) throws IOException {
        String resourcePath = "/" + SystemArch.getLibraryFold() + "/" + libName;
        if (temporaryDir == null) {
            temporaryDir = NativeUtils.createTempDirectory();
            temporaryDir.deleteOnExit();
        }
        File tempFile = new File(temporaryDir, libName);
        try (InputStream is = NativeUtils.class.getResourceAsStream(resourcePath);){
            Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            tempFile.setWritable(true, false);
            tempFile.setExecutable(true, false);
            tempFile.setReadable(true, false);
        }
        catch (IOException e) {
            tempFile.delete();
            throw e;
        }
        catch (NullPointerException e) {
            tempFile.delete();
            throw new FileNotFoundException("File " + resourcePath + " was not found inside JAR.");
        }
        return tempFile;
    }
}

