package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.domain.Middle;
import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import java.time.Instant;

/**
 * 启动容器
 *
 * @author fobgo
 * @date 2022/2/16 9:17
 */
@Mojo(name = "deploy")
public class DeployMojo extends AbstractDapMojo {

    @Parameter(property = "startFile", defaultValue = "doc/run/startup.sh")
    private String startFile;

    private static String toDuration(long time) {
        long second = time / 1000;
        long day = second / 86400;
        second = second % 86400;
        long hour = second / 3600;
        second = second % 3600;
        long minute = second / 60;
        second = second % 60;

        String duration = second + " 秒";
        if (minute > 0) {
            duration = minute + " 分钟 " + duration;
        }
        if (hour > 0) {
            duration = hour + " 小时 " + duration;
        }
        if (day > 0) {
            duration = day + " 天 " + duration;
        }
        return duration;
    }

    @Override
    public void execute() throws MojoExecutionException {
        Instant now = Instant.now();

        DockerUtils.instance(new Shell(host, port, username, password)).deploy(startFile);

        Middle middle = Middle.valueOf(imageName.replace("-api", "").toUpperCase());

        String uri = String.format("http://%s:%s", host, middle.port());
        getLog().info("---------------------------[ health check ]-----------------------------");

        boolean areYouOK = DockerUtils.instance(new Shell(host, port, username, password)).areYouOK(uri);

        getLog().info("------------------------------------------------------------------------");
        if (areYouOK) {
            long elapsed = System.currentTimeMillis() - now.toEpochMilli();

            getLog().info(String.format("%s:%s 部署成功, 共耗时：%s.", imageName, imageTag, toDuration(elapsed)));
            getLog().info(String.format("首页地址: %s", uri));
            String envUri = String.format("%s/api/%s/v2/env", uri, middle.name().toLowerCase());
            getLog().info(String.format("环境地址: %s", envUri));
            String actuatorUri = String.format("%s/%s/actuator", uri, middle.name().toLowerCase());
            getLog().info(String.format("监控地址: %s", actuatorUri));
        } else {
            getLog().info(String.format("%s:%s 部署失败. 请继续等待.", imageName, imageTag));
        }
        getLog().info("------------------------------------------------------------------------");

        // if ( null == arguments )
        // {
        //     arguments = new String[0];
        // }
        //
        // StringBuffer msg = new StringBuffer( "Invoking : " );
        // msg.append( mainClass );
        // msg.append( ".main(" );
        // for ( int i = 0; i < arguments.length; i++ )
        // {
        //     if ( i > 0 )
        //     {
        //         msg.append( ", " );
        //     }
        //     msg.append( arguments[i] );
        // }
        // msg.append( ")" );
        // getLog().info( msg );
        //
        // int sepIndex = mainClass.indexOf('/');
        //
        // final String bootClassName;
        // if (sepIndex >= 0) {
        //     bootClassName = mainClass.substring(sepIndex + 1);
        // } else {
        //     bootClassName = mainClass;
        // }
        //
        // try {
        //     Class<?> bootClass = Thread.currentThread().getContextClassLoader().loadClass(bootClassName);
        //
        //     MethodHandles.Lookup lookup = MethodHandles.lookup();
        //
        //     MethodHandle mainHandle =
        //             lookup.findStatic(bootClass, "main",
        //                     MethodType.methodType(void.class, String[].class));
        //
        //     mainHandle.invoke(arguments);
        // } catch (IllegalAccessException e) { // just pass it on
        //     Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(),
        //             new Exception("The specified mainClass doesn't contain a main method with appropriate signature.",
        //                     e));
        // } catch (InvocationTargetException e) { // use the cause if available to improve the plugin execution output
        //     Throwable exceptionToReport = e.getCause() != null ? e.getCause() : e;
        //     Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), exceptionToReport);
        // } catch (Throwable e) { // just pass it on
        //     Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
        // }
    }

}
