package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

/**
 * rm container
 *
 * @author fobgo
 * @date 2022/2/16 9:18
 */
//@Mojo(name = "remove-container")
public class RemoveContainerMojo extends AbstractDapMojo {

    @Override
    public void execute() throws MojoExecutionException {
        try {
            DockerUtils.instance(new Shell(host, port, username, password)).removeContainer(imageName);
            getLog().info("remove container " + imageName + ":" + imageTag);
        } catch (Exception e) {
            getLog().error("remove container fail.", e);
        }
    }
}
