package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

/**
 * rmi image
 *
 * @author fobgo
 * @date 2022/2/16 9:18
 */
//@Mojo(name = "remove-image")
public class RemoveImageMojo extends AbstractDapMojo {

    @Override
    public void execute() throws MojoExecutionException {
        try {
            DockerUtils.instance(new Shell(host, port, username, password)).removeImage(imageName, imageTag);
            getLog().info("remove image " + imageName + ":" + imageTag);
        } catch (Exception e) {
            getLog().error("remove image fail.", e);
        }
    }
}
