package com.digiwin.dap.middleware.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

import java.util.concurrent.TimeUnit;

/**
 * 启动容器、导出镜像
 *
 * @author seven
 * @date 2021/1/15
 */
public class DockerUtils {

    private static final Log logger = new SystemStreamLog();

    private final Session session;

    private DockerUtils(Shell shell) {
        this.session = SshUtil.getSession(shell);
    }

    public static DockerUtils instance(Shell shell) {
        return new DockerUtils(shell);
    }

    public static void main(String[] args) throws Exception {
        DockerUtils.instance(new Shell()).deploy("doc/run/startup.sh");
        DockerUtils.instance(new Shell()).export(args[0], args[1], "doc");
    }

    public void connect() throws JSchException {
        session.connect(Shell.CONNECT_TIMEOUT);
        if (session.isConnected()) {
            logger.info(String.format("Host(%s) connected.", session.getHost()));
        }
    }

    public void deploy(String source) {
        try {
            this.connect();
            SshUtil.exec(session, "mkdir /tmp/deploy");
            ScpUtil.scpTo(session, source, "/tmp/deploy/startup.sh");
            SshUtil.exec(session, "sh /tmp/deploy/startup.sh");
            SshUtil.exec(session, "rm -rf /tmp/deploy");
        } catch (Exception e) {
            logger.error(String.format("deploy fail %s", e.getMessage()));
        } finally {
            SshUtil.close(session);
        }
    }

    public boolean areYouOK(String uri) {
        boolean success = false;
        try {
            this.connect();
            for (int i = 1; i <= 100; i++) {
                logger.debug("第" + i + "次检查：");
                String result = SshUtil.exec(session, "curl " + uri).get(0);
                if (result != null && result.contains("version")) {
                    success = true;
                    break;
                }
                TimeUnit.SECONDS.sleep(3);
            }
        } catch (Exception e) {
            logger.error(String.format("are you ok fail %s", e.getMessage()));
        } finally {
            SshUtil.close(session);
        }
        return success;
    }

    public void export(String project, String version, String exportPath) {
        try {
            this.connect();
            SshUtil.exec(session, "mkdir /tmp/image");
            SshUtil.exec(session, String.format("docker save -o /tmp/image/%s-%s.tar %s:%s", project, version, project, version));
            ScpUtil.scpFrom(session, String.format("/tmp/image/%s-%s.tar", project, version), String.format("%s/%s-%s.tar", exportPath, project, version));
            SshUtil.exec(session, "rm -rf /tmp/image");
        } catch (Exception e) {
            logger.error(String.format("build fail %s", e.getMessage()));
        } finally {
            SshUtil.close(session);
        }
    }

    public void build(String source, String project, String version) {
        try {
            this.connect();
            SshUtil.exec(session, "mkdir -p /tmp/build/src");
            ScpUtil.scpTo(session, source + "target/" + project + "-" + version + ".tar.gz", "/tmp/build");
            ScpUtil.scpTo(session, source + "Dockerfile", "/tmp/build");
            ScpUtil.scpTo(session, source + "pom.xml", "/tmp/build");
            SshUtil.exec(session, String.format("tar -zxvf /tmp/build/%s-%s.tar.gz -C /tmp/build/src/", project, version));
            SshUtil.exec(session, String.format("cd /tmp/build && docker build -t %s:%s .", project, version));
            SshUtil.exec(session, "docker images | grep " + project);
            SshUtil.exec(session, "rm -rf /tmp/build");
        } catch (Exception e) {
            logger.error(String.format("build fail %s", e.getMessage()));
        } finally {
            SshUtil.close(session);
        }
    }

    public void removeContainer(String project) {
        try {
            this.connect();
            SshUtil.exec(session, String.format("docker rm -f $(docker ps --filter name=%sContainer -q)", project));
        } catch (JSchException e) {
            e.printStackTrace();
        }
    }

    public void removeImage(String project, String version) {
        try {
            this.connect();
            SshUtil.exec(session, String.format("docker rmi %s:%s", project, version));
        } catch (JSchException e) {
            e.printStackTrace();
        }
    }
}
