/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateRange;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.nlf.calendar.Lunar;
import com.nlf.calendar.Solar;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MoYuUtils {
    private static final String TIPS_MSG = "\u3010\u6478\u9c7c\u603b\u529e\u3011\u63d0\u9192\u60a8\uff1a\n\n{}\u6708{}\u65e5 {}\u597d\uff0c\u6253\u5de5\u4eba\uff01{}\n\n\u8ddd\u79bb\u5468\u672b\u8fd8\u6709{}\u5929\n{}\n{}\n\n\u6b22\u8fce\u52a0\u5165\u6478\u9c7c\u6280\u672f\u4ea4\u6d41\u7fa4\uff1a10241048576";
    private static final List<String> hellos = Arrays.asList("\u6478\u9c7c\u80fd\u589e\u52a0\u5de5\u4f5c\u52a8\u529b\uff0c\u6478\u9c7c\u80fd\u653e\u677e\u7b4b\u9aa8\u8212\u5c55\u795e\u7ecf\u3002\u4eba\u90fd\u662f\u88ab\u6478\u9c7c\u6478\u5927\u7684\uff0c\u6478\u9c7c\u662f\u4eba\u7684\u5929\u6027\uff0c\u65e0\u8bba\u662f\u987a\u5883\u8fd8\u662f\u9006\u5883\uff0c\u5de5\u4f5c\u6478\u9c7c\uff0c\u624d\u4e0d\u4f1a\u88ab\u5de5\u4f5c\u629b\u5f03\u3002", "\u5de5\u4f5c\u518d\u7d2f\uff0c\u4e00\u5b9a\u4e0d\u8981\u5fd8\u8bb0\u6478\u9c7c\u54e6\uff01\u6709\u4e8b\u6ca1\u4e8b\u8d77\u8eab\u53bb\u8336\u6c34\u95f4\uff0c\u53bb\u5395\u6240\uff0c\u53bb\u5eca\u9053\u8d70\u8d70\u522b\u8001\u5728\u5de5\u4f4d\u4e0a\u5750\u7740\uff0c\u94b1\u662f\u8001\u677f\u7684,\u4f46\u547d\u662f\u81ea\u5df1\u7684\u3002", "\u751f\u6d3b\u9700\u8981\u6478\u9c7c\uff0c\u800c\u4e0d\u662f\u8ba4\u771f\u5de5\u4f5c\u3002\u6709\u65f6\u5019\u4f60\u9700\u8981\u6478\u9c7c\uff0c\u8ba9\u5de5\u4f5c\u987a\u5176\u81ea\u7136\uff0c\u4e0d\u8981\u8fc7\u5206\u62c5\u5fc3\uff0c\u4e5f\u4e0d\u8981\u8fc7\u4e8e\u7ec6\u81f4\u7684\u89c4\u5212\u3002\u5b66\u4f1a\u6478\u9c7c\uff0c\u4e0d\u8981\u903c\u81ea\u5df1\u903c\u5f97\u592a\u7d27\u3002\u6df1\u547c\u5438\u3002\u5c18\u57c3\u843d\u5b9a\u65f6\u4f60\u4f1a\u518d\u6b21\u770b\u89c1\u68ee\u6797\u4e2d\u7684\u6811\u6728\u3002");
    private static final List<String> end = Arrays.asList("\u8ba4\u8ba4\u771f\u771f\u4e0a\u73ed\uff0c\u8fd9\u6839\u672c\u5c31\u4e0d\u53eb\u8d5a\u94b1\uff0c\u90a3\u662f\u7528\u52b3\u52a8\u6362\u53d6\u62a5\u916c\u3002\u53ea\u6709\u5077\u61d2\uff0c\u5728\u4e0a\u73ed\u7684\u65f6\u5019\u6478\u9c7c\u5212\u6c34\uff0c\u4f60\u624d\u662f\u4ece\u8001\u677f\u624b\u91cc\u8d5a\u5230\u4e86\u94b1\u3002\u6700\u540e\uff0c\u795d\u613f\u5929\u4e0b\u6240\u6709\u6478\u9c7c\u4eba\u90fd\u80fd\u6109\u5feb\u7684\u6e21\u8fc7\u6bcf\u4e00\u5929\uff01", "\u5de5\u4f5c\u518d\u7d2f\uff0c\u4e00\u5b9a\u4e0d\u8981\u5fd8\u8bb0\u6478\u9c7c\u54e6\uff01\u6709\u4e8b\u6ca1\u4e8b\u8d77\u8eab\u53bb\u8336\u6c34\u95f4\uff0c\u53bb\u5395\u6240\uff0c\u53bb\u5eca\u9053\u8d70\u8d70\u522b\u8001\u5728\u5de5\u4f4d\u4e0a\u5750\u7740\uff0c\u94b1\u662f\u8001\u677f\u7684,\u4f46\u547d\u662f\u81ea\u5df1\u7684\u3002", "\u751f\u6d3b\u9700\u8981\u6478\u9c7c\uff0c\u800c\u4e0d\u662f\u8ba4\u771f\u5de5\u4f5c\u3002\u6709\u65f6\u5019\u4f60\u9700\u8981\u6478\u9c7c\uff0c\u8ba9\u5de5\u4f5c\u987a\u5176\u81ea\u7136\uff0c\u4e0d\u8981\u8fc7\u5206\u62c5\u5fc3\uff0c\u4e5f\u4e0d\u8981\u8fc7\u4e8e\u7ec6\u81f4\u7684\u89c4\u5212\u3002\u5b66\u4f1a\u6478\u9c7c\uff0c\u4e0d\u8981\u903c\u81ea\u5df1\u903c\u5f97\u592a\u7d27\u3002\u6df1\u547c\u5438\u3002\u5c18\u57c3\u843d\u5b9a\u65f6\u4f60\u4f1a\u518d\u6b21\u770b\u89c1\u68ee\u6797\u4e2d\u7684\u6811\u6728\u3002");
    private static final List<String> FESTIVAL_FILTER = CollUtil.newArrayList((Object[])new String[]{"\u5143\u65e6\u8282", "\u6625\u8282", "\u6e05\u660e", "\u52b3\u52a8\u8282", "\u7aef\u5348\u8282", "\u4e2d\u79cb\u8282", "\u56fd\u5e86\u8282"});

    public static String holiday() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextWeek = now.with(TemporalAdjusters.next(DayOfWeek.of(6)));
        Map<String, Long> holidayMap = MoYuUtils.computeHoliday();
        StringBuffer fStr = new StringBuffer();
        holidayMap.forEach((f, l) -> fStr.append(StrUtil.format((CharSequence)"\u8ddd\u79bb{}\u8fd8\u6709{}\u5929\n", (Object[])new Object[]{f, l})));
        return StrUtil.format((CharSequence)TIPS_MSG, (Object[])new Object[]{now.getMonthValue(), now.getDayOfMonth(), MoYuUtils.amOrPm(now.getHour()), hellos.get(RandomUtil.randomInt((int)hellos.size())), Duration.between(now, nextWeek).toDays(), fStr, end.get(RandomUtil.randomInt((int)end.size()))});
    }

    public static Map<String, Long> computeHoliday() {
        DateTime date = DateUtil.date();
        DateTime today = DateUtil.date();
        DateTime dateTime = date.offset(DateField.YEAR, 1);
        DateTime end = DateUtil.endOfYear((Date)dateTime);
        DateRange range = DateUtil.range((Date)today, (Date)end, (DateField)DateField.DAY_OF_YEAR);
        LinkedHashMap<String, Long> festivalMap = new LinkedHashMap<String, Long>(366);
        for (DateTime time : range) {
            Solar solar = Solar.fromDate((Date)time);
            List festivals = (List)Opt.ofNullable((Object)solar.getFestivals()).orElse(Collections.emptyList());
            Lunar lunar = Lunar.fromDate((Date)time);
            festivals.addAll(lunar.getFestivals());
            String jieQi = StrUtil.blankToDefault((CharSequence)lunar.getJieQi(), null);
            if (StrUtil.equals((CharSequence)jieQi, (CharSequence)"\u6e05\u660e")) {
                festivals.add("\u6e05\u660e");
            }
            if (!CollUtil.containsAny((Collection)festivals, FESTIVAL_FILTER)) continue;
            festivals.remove("\u6559\u5e08\u8282");
            String festival = CollUtil.join((Iterable)festivals, (CharSequence)",");
            if (null != festivalMap.get(festival)) continue;
            festivalMap.put(festival, DateUtil.between((Date)today, (Date)time, (DateUnit)DateUnit.DAY));
        }
        return festivalMap;
    }

    public static String amOrPm(int a) {
        if (a >= 0 && a <= 6) {
            return "\u51cc\u6668";
        }
        if (a > 6 && a < 12) {
            return "\u4e0a\u5348";
        }
        if (a == 12) {
            return "\u4e2d\u5348";
        }
        if (a >= 13 && a <= 18) {
            return "\u4e0b\u5348";
        }
        return "\u665a\u4e0a";
    }
}

