/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.mojo.AbstractDapMojo;
import com.spotify.docker.client.AnsiProgressHandler;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="build")
public class BuildMojo
extends AbstractDapMojo {
    @Parameter(defaultValue="${project.build.directory}")
    private String buildDirectory;
    @Parameter(defaultValue="${project.build.finalName}.jar")
    private String jarName;
    @Parameter(property="dockerDirectory", defaultValue="${project.basedir}/src/main/resources/docker")
    private String dockerDirectory;

    public void execute() throws MojoExecutionException {
        try {
            Path targetPath = this.getTargetPath();
            this.copyFiles(targetPath);
            DockerClient docker = this.buildClient();
            this.buildImage(docker, targetPath);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Build image fail.", (Throwable)e);
        }
    }

    private void copyFiles(Path targetPath) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(this.dockerDirectory));
        scanner.scan();
        for (String included : scanner.getIncludedFiles()) {
            Path source = Paths.get(this.dockerDirectory, new String[0]).resolve(included);
            Path target = targetPath.resolve(included);
            this.getLog().info((CharSequence)String.format("Copying %s -> %s", source, target));
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        Path source = Paths.get(this.buildDirectory, new String[0]).resolve(this.jarName);
        Path target = targetPath.resolve(this.jarName);
        this.getLog().info((CharSequence)String.format("Copying %s -> %s", source, target));
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    private DockerClient buildClient() throws MojoExecutionException {
        DefaultDockerClient.Builder builder;
        try {
            builder = DefaultDockerClient.fromEnv().readTimeoutMillis(0L);
            builder.uri(String.format("http://%s:2375", this.host));
        }
        catch (DockerCertificateException ex) {
            throw new MojoExecutionException("Cannot build DockerClient due to certificate problem", (Exception)((Object)ex));
        }
        return builder.build();
    }

    private void buildImage(DockerClient docker, Path buildDir) throws Exception {
        String fullImageName = "middleware/" + this.imageName + ":" + this.imageTag;
        this.getLog().info((CharSequence)("Building image " + fullImageName));
        docker.build(buildDir, fullImageName, (ProgressHandler)new AnsiProgressHandler(), new DockerClient.BuildParam[0]);
        this.getLog().info((CharSequence)("Built " + fullImageName));
    }

    private Path getTargetPath() {
        return Paths.get(this.buildDirectory, "docker");
    }
}

