/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.domain.Middle;
import com.digiwin.dap.middleware.mojo.AbstractDapMojo;
import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy")
public class DeployMojo
extends AbstractDapMojo {
    @Parameter(property="startFile", defaultValue="doc/run/startup.sh")
    private String startFile;

    private static String toDuration(long time) {
        long second = time / 1000L;
        long day = second / 86400L;
        long hour = (second %= 86400L) / 3600L;
        long minute = (second %= 3600L) / 60L;
        String duration = (second %= 60L) + " \u79d2";
        if (minute > 0L) {
            duration = minute + " \u5206\u949f " + duration;
        }
        if (hour > 0L) {
            duration = hour + " \u5c0f\u65f6 " + duration;
        }
        if (day > 0L) {
            duration = day + " \u5929 " + duration;
        }
        return duration;
    }

    private static CommandLine parse(String[] arguments) throws ParseException {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("n", "name", true, "name of container");
        options.addOption("p", "port", true, "port of container");
        options.addOption("e", true, "environment of container");
        options.addOption("v", "volume", true, "volume of container");
        options.addOption("idt", false, "idt of container");
        options.addOption("", "restart", true, "restart of container");
        options.addOption("", "privileged", true, "privileged of container");
        return parser.parse(options, arguments);
    }

    public void execute() throws MojoExecutionException {
        String appName;
        int appPort;
        Instant now = Instant.now();
        Shell shell = new Shell(this.host, this.port, this.username, this.password);
        DockerUtils.instance(shell).deploy(this.startFile);
        try {
            List<String> dockers = Files.readAllLines(Paths.get(this.startFile, new String[0]));
            Optional<String> dockerRunPort = dockers.stream().filter(p -> p.startsWith("PORT")).findFirst();
            Optional<String> dockerRunName = dockers.stream().filter(p -> p.startsWith("NAME")).findFirst();
            if (dockerRunPort.isPresent() && dockerRunName.isPresent()) {
                appPort = Integer.parseInt(dockerRunPort.get().replace("PORT=", ""));
                appName = dockerRunName.get().replace("NAME=", "").replace("-$PORT", "");
            } else {
                String dockerRun = dockers.stream().filter(p -> p.startsWith("docker run")).findFirst().get();
                CommandLine cli = DeployMojo.parse(dockerRun.split(" "));
                String optionName = cli.getOptionValue("n");
                appPort = Integer.parseInt(cli.getOptionValue("p").split(":")[0]);
                appName = optionName.replace("-" + appPort, "").toLowerCase();
            }
        }
        catch (Exception e) {
            try {
                String middleName = this.imageName.replace("-api", "").replace("dapware", "");
                Middle middle = Middle.valueOf(middleName.toUpperCase());
                appName = middle.name().toLowerCase();
                appPort = middle.port();
            }
            catch (Exception ex) {
                this.getLog().info((CharSequence)"\u65e0\u6cd5\u786e\u5b9a\u5177\u4f53\u4e2d\u95f4\u4ef6\uff0c\u8bf7\u81ea\u884c\u68c0\u67e5\u662f\u5426\u90e8\u7f72\u6210\u529f\u3002");
                return;
            }
        }
        String uri = String.format("http://%s:%s", this.host, appPort);
        this.getLog().info((CharSequence)"---------------------------[ health check ]-----------------------------");
        boolean areYouOK = DockerUtils.instance(shell).areYouOK(uri);
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        if (areYouOK) {
            long elapsed = System.currentTimeMillis() - now.toEpochMilli();
            this.getLog().info((CharSequence)String.format("%s:%s \u90e8\u7f72\u6210\u529f, \u5171\u8017\u65f6\uff1a%s.", this.imageName, this.imageTag, DeployMojo.toDuration(elapsed)));
            this.getLog().info((CharSequence)String.format("\u9996\u9875\u5730\u5740: %s", uri));
            String envUri = String.format("%s/api/%s/v2/env", uri, appName);
            this.getLog().info((CharSequence)String.format("\u73af\u5883\u5730\u5740: %s", envUri));
            String actuatorUri = String.format("%s/%s/actuator", uri, appName);
            this.getLog().info((CharSequence)String.format("\u76d1\u63a7\u5730\u5740: %s", actuatorUri));
        } else {
            this.getLog().info((CharSequence)String.format("%s:%s \u90e8\u7f72\u5931\u8d25. \u8bf7\u7ee7\u7eed\u7b49\u5f85.", this.imageName, this.imageTag));
        }
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }
}

