/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.ssh;

import com.digiwin.dap.middleware.ssh.ScpUtil;
import com.digiwin.dap.middleware.ssh.Shell;
import com.digiwin.dap.middleware.ssh.SshUtil;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class DockerUtils {
    private static final Log logger = new SystemStreamLog();
    private final Session session;

    private DockerUtils(Shell shell) {
        this.session = SshUtil.getSession(shell);
    }

    public static DockerUtils instance(Shell shell) {
        return new DockerUtils(shell);
    }

    public static void main(String[] args) throws Exception {
        DockerUtils.instance(new Shell()).deploy("doc/run/startup.sh");
        DockerUtils.instance(new Shell()).export(args[0], args[1], "doc");
    }

    public void connect() throws JSchException {
        this.session.connect(0);
        if (this.session.isConnected()) {
            logger.info((CharSequence)String.format("Host(%s) connected.", this.session.getHost()));
        }
    }

    public void deploy(String source) {
        try {
            this.connect();
            SshUtil.exec(this.session, "mkdir /tmp/deploy");
            ScpUtil.scpTo(this.session, source, "/tmp/deploy/startup.sh");
            SshUtil.exec(this.session, "sh /tmp/deploy/startup.sh");
            SshUtil.exec(this.session, "rm -rf /tmp/deploy");
        }
        catch (Exception e) {
            logger.error((CharSequence)String.format("deploy fail %s", e.getMessage()));
        }
        finally {
            SshUtil.close(this.session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areYouOK(String uri) {
        boolean success = false;
        try {
            this.connect();
            for (int i = 1; i <= 100; ++i) {
                logger.debug((CharSequence)("\u7b2c" + i + "\u6b21\u68c0\u67e5\uff1a"));
                String result = SshUtil.exec(this.session, " curl -s -w \"%{http_code}\" -o /dev/null " + uri).get(0);
                if ("200".equals(result)) {
                    success = true;
                    break;
                }
                TimeUnit.SECONDS.sleep(3L);
            }
        }
        catch (Exception e) {
            logger.error((CharSequence)String.format("are you ok fail %s", e.getMessage()));
        }
        finally {
            SshUtil.close(this.session);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String project, String version, String exportPath) {
        try {
            this.connect();
            SshUtil.exec(this.session, "mkdir /tmp/image");
            SshUtil.exec(this.session, String.format("docker save -o /tmp/image/%s-%s.tar middleware/%s:%s", project, version, project, version));
            ScpUtil.scpFrom(this.session, String.format("/tmp/image/%s-%s.tar", project, version), String.format("%s/%s-%s.tar", exportPath, project, version));
            SshUtil.exec(this.session, "rm -rf /tmp/image");
        }
        catch (Exception e) {
            logger.error((CharSequence)String.format("build fail %s", e.getMessage()));
        }
        finally {
            SshUtil.close(this.session);
        }
    }

    public void removeContainer(String name) {
        try {
            this.connect();
            SshUtil.exec(this.session, "docker rm -f " + name);
        }
        catch (Exception e) {
            logger.error((CharSequence)String.format("shutdown fail %s", e.getMessage()));
        }
        finally {
            SshUtil.close(this.session);
        }
    }

    public void removeImage() {
        try {
            this.connect();
            SshUtil.exec(this.session, "docker rmi $(docker images | grep \"none\" | awk '{print $3}')");
        }
        catch (JSchException e) {
            logger.error((CharSequence)String.format("remove images fail %s", e.getMessage()));
        }
    }
}

