package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;

/**
 * 删除容器
 *
 * @author fobgochod
 * @date 2023/5/15 14:05
 */
@Mojo(name = "remove-container")
public class RemoveContainerMojo extends AbstractDapMojo {

    @Parameter(property = "startFile", defaultValue = "doc/run/startup.sh")
    private String startFile;

    @Override
    public void execute() throws MojoExecutionException {
        try {
            List<String> dockers = Files.readAllLines(Paths.get(startFile));

            Optional<String> dockerRunPort = dockers.stream().filter(p -> p.startsWith("PORT")).findFirst();
            Optional<String> dockerRunName = dockers.stream().filter(p -> p.startsWith("NAME")).findFirst();

            if (dockerRunPort.isPresent() && dockerRunName.isPresent()) {
                String appPort = dockerRunPort.get().replace("PORT=", "");
                String appName = dockerRunName.get().replace("NAME=", "").replace("$PORT", appPort);

                DockerUtils.instance(new Shell(host, port, username, password)).removeContainer(appName);

                getLog().info(String.format("删除容器：%s", appName));
            }
        } catch (Exception e) {
            getLog().info("删除容器失败，请自行连接服务器手动删除。");
        }
    }
}
