/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.mojo.AbstractDapMojo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="remove-local-jar")
public class RemoveLocalJarMojo
extends AbstractDapMojo {
    @Parameter(property="dapwareVersion", defaultValue="2.7.0")
    private String dapwareVersion;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.deleteJar();
    }

    private void deleteJar() {
        String basePath = this.settings.getLocalRepository() + "/com/digiwin/dap/middleware/";
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(basePath));
        scanner.scan();
        for (String included : scanner.getIncludedFiles()) {
            Path source = Paths.get(basePath, new String[0]).resolve(included);
            File file = source.toFile();
            if (!file.getParentFile().getName().equals(this.dapwareVersion) && !file.getAbsolutePath().contains("pagehelper")) continue;
            if (file.delete()) {
                this.getLog().info((CharSequence)String.format("Deleting %s", file.getAbsolutePath()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("Deleted fail %s", file.getAbsolutePath()));
        }
    }
}

