/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.ssh;

import com.digiwin.dap.middleware.ssh.Shell;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class SshUtil {
    private static final Log logger = new SystemStreamLog();

    public static Session getSession(Shell shell) {
        try {
            JSch jSch = new JSch();
            if (Files.exists(Paths.get(shell.getIdentity(), new String[0]), new LinkOption[0])) {
                jSch.addIdentity(shell.getIdentity(), shell.getPassphrase());
            }
            Session session = jSch.getSession(shell.getUsername(), shell.getHost(), shell.getPort());
            session.setPassword(shell.getPassword());
            session.setConfig("StrictHostKeyChecking", "no");
            return session;
        }
        catch (Exception e) {
            logger.error((CharSequence)"JSch create session error:", (Throwable)e);
            return null;
        }
    }

    public static void close(Session session) {
        if (session != null) {
            try {
                session.disconnect();
            }
            catch (Exception e) {
                logger.error((CharSequence)"JSch channel disconnect error:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> exec(Session session, String command) throws JSchException {
        logger.debug((CharSequence)String.format(">> %s", command));
        ArrayList<String> resultLines = new ArrayList<String>();
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            channel.setPty(true);
            InputStream is = channel.getInputStream();
            channel.connect(0);
            try {
                String inputLine;
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(is));
                while ((inputLine = inputReader.readLine()) != null) {
                    logger.debug((CharSequence)String.format("   %s", inputLine));
                    resultLines.add(inputLine);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error((CharSequence)"JSch inputStream close error:", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error((CharSequence)"IOException:", (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception e) {
                    logger.error((CharSequence)"JSch channel disconnect error:", (Throwable)e);
                }
            }
        }
        return resultLines;
    }
}

