/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.config;

import com.alibaba.druid.wall.WallConfig;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.mybatis.interceptor.InjectionInterceptor;
import com.github.pagehelper.PageInterceptor;
import java.util.Properties;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class MyBatisConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyBatisConfig.class);
    private static final String MYBATIS_VARIABLES_AES_KEY = "aesKey";
    @Autowired
    private Environment environment;

    @Bean
    public ConfigurationCustomizer sqlInjectionInterceptor() {
        WallConfig config = new WallConfig("META-INF/druid/wall/mysql");
        config.setConditionAndAlwayFalseAllow(true);
        InjectionInterceptor injectionInterceptor = new InjectionInterceptor(config);
        LOGGER.info("===>MyBatis\u9632SQL\u6ce8\u5165\u62e6\u622a\u5668\u521d\u59cb\u5316");
        return configuration -> configuration.addInterceptor((Interceptor)injectionInterceptor);
    }

    @Bean
    @ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('pagehelper.helper-dialect'))}")
    public ConfigurationCustomizer pageInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", this.environment.getProperty("pagehelper.helper-dialect"));
        properties.setProperty("reasonable", this.environment.getProperty("pagehelper.reasonable"));
        properties.setProperty("supportMethodsArguments", this.environment.getProperty("pagehelper.support-methods-arguments"));
        properties.setProperty("params", this.environment.getProperty("pagehelper.params"));
        pageInterceptor.setProperties(properties);
        LOGGER.info("===>MyBatis\u5206\u9875\u62e6\u622a\u5668\u521d\u59cb\u5316");
        return configuration -> configuration.addInterceptor((Interceptor)pageInterceptor);
    }

    @Bean
    public ConfigurationCustomizer customGlobalVariables() {
        Properties properties = new Properties();
        properties.setProperty(MYBATIS_VARIABLES_AES_KEY, KeyConstant.DIGIWIN);
        LOGGER.info("===>MyBatis\u8bbe\u5b9a\u5168\u5c40\u53c2\u6570");
        return configuration -> configuration.setVariables(properties);
    }
}

