/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.pagehelper;

import com.digiwin.dap.middleware.mybatis.pagehelper.CustomPageSettingsHolder;
import com.github.pagehelper.JSqlParser;
import com.github.pagehelper.parser.CountSqlParser;
import java.util.ArrayList;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SubSelect;

public class CustomCountSqlParser
extends CountSqlParser {
    private static final Alias TABLE_ALIAS = new Alias("table_count");
    private JSqlParser jSqlParser;

    public CustomCountSqlParser(JSqlParser jSqlParser) {
        super(jSqlParser);
        this.jSqlParser = jSqlParser;
    }

    public JSqlParser getjSqlParser() {
        return this.jSqlParser;
    }

    public void setjSqlParser(JSqlParser jSqlParser) {
        this.jSqlParser = jSqlParser;
    }

    public void sqlToCount(Select select, String name) {
        SelectBody selectBody = select.getSelectBody();
        ArrayList<SelectExpressionItem> COUNT_ITEM = new ArrayList<SelectExpressionItem>();
        COUNT_ITEM.add(new SelectExpressionItem((Expression)new Column("count(" + name + ")")));
        if (selectBody instanceof PlainSelect && (CustomPageSettingsHolder.isSimpleCountSql().booleanValue() || this.isSimpleCount((PlainSelect)selectBody))) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            plainSelect.setSelectItems(COUNT_ITEM);
            plainSelect.setDistinct(null);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public String getSmartCountSql(String sql, String countColumn) {
        Statement stmt = null;
        if (sql.indexOf("/*keep orderby*/") < 0 && !this.keepOrderBy()) {
            String hints;
            Token token;
            try {
                stmt = this.jSqlParser.parse(sql);
            }
            catch (Throwable var10) {
                return this.getSimpleCountSql(sql);
            }
            Select select = (Select)stmt;
            SelectBody selectBody = select.getSelectBody();
            try {
                this.processSelectBody(selectBody);
            }
            catch (Exception var9) {
                return this.getSimpleCountSql(sql);
            }
            this.processWithItemsList(select.getWithItemsList());
            this.sqlToCount(select, countColumn);
            String result = select.toString();
            if (selectBody instanceof PlainSelect && (token = ((PlainSelect)selectBody).getASTNode().jjtGetFirstToken().specialToken) != null && (hints = token.toString().trim()).startsWith("/*") && hints.endsWith("*/") && !result.startsWith("/*")) {
                result = hints + result;
            }
            return result;
        }
        return this.getSimpleCountSql(sql, countColumn);
    }

    static {
        TABLE_ALIAS.setUseAs(false);
    }
}

