package com.digiwin.dap.middleware.mybatis.config;

import com.digiwin.dap.middle.database.encrypt.config.DatabaseEncryptConfig;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middleware.mybatis.interceptor.DecryptResultInterceptor;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author michael
 */
@Configuration
@ConditionalOnBean(DatabaseEncryptConfig.class)
public class MyBatisEncryptConfig {

    private final static Logger LOGGER = LoggerFactory.getLogger(MyBatisEncryptConfig.class);

    @Autowired
    @Qualifier("desensitizationConverter")
    private DesensitizationConverter<Object> desensitizationConverter;

    @Autowired
    @Qualifier("sqlParser")
    private SqlParser sqlParser;

    /**
     * mybatis实现数据库加密相关配置
     *
     * @return org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer
     **/
    @Bean
    public ConfigurationCustomizer encryptedStorageMyBatisConfigurationCustomizer() {
        LOGGER.debug("===>MyBatis加密存储相关插件初始化");
        return configuration -> {
            // 全局注册TypeHandler(暂时不需要全局注册)
//             configuration.getTypeHandlerRegistry().register(AesTypeHandler.class);
            // 全局注册拦截器
            // 1.结果集解密拦截器
            DecryptResultInterceptor decryptResultInterceptor = new DecryptResultInterceptor(desensitizationConverter, sqlParser);
            configuration.addInterceptor(decryptResultInterceptor);
        };
    }

}
