package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middle.database.encrypt.desensitization.processor.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;
import com.digiwin.dap.middleware.util.SpringBeansUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

/**
 * @author michael
 * <p>mybatis自定义TypeHandler,对指定参数进行aes加密以及指定返回字段aes解密</p>
 */
public class AesTypeHandler extends BaseTypeHandler<String> {

    private final static Logger LOGGER = LoggerFactory.getLogger(AesTypeHandler.class);

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, desensitize(String.valueOf(i), parameter));
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return revert(columnName, rs.getString(columnName));
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return revert(String.valueOf(columnIndex), rs.getString(columnIndex));
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return revert(String.valueOf(columnIndex), cs.getString(columnIndex));
    }

    private String revert(String field, String value) {
        try {
            DesensitizationProcessorRegistry desensitizationProcessorRegistry = SpringBeansUtils.getBean(DesensitizationProcessorRegistry.class);
            if (Objects.isNull(desensitizationProcessorRegistry)) {
                LOGGER.error("===>AesTypeHandler revert error,processor not found");
                return value;
            }
            DesensitizationProcessor desensitizationProcessor = desensitizationProcessorRegistry.findDesensitizationProcessor(DesensitizationModeEnum.AES);
            LOGGER.debug("===>AesTypeHandler revert,column name:{}", field);
            return desensitizationProcessor.revert("", field, value);
        } catch (Exception e) {
            LOGGER.error("===>AesTypeHandler revert error,column name:{}", field, e);
            return value;
        }

    }

    private String desensitize(String field, String value) {
        try {
            DesensitizationProcessorRegistry desensitizationProcessorRegistry = SpringBeansUtils.getBean(DesensitizationProcessorRegistry.class);
            if (Objects.isNull(desensitizationProcessorRegistry)) {
                LOGGER.error("===>AesTypeHandler desensitize error,processor not found");
                return value;
            }
            DesensitizationProcessor desensitizationProcessor = desensitizationProcessorRegistry.findDesensitizationProcessor(DesensitizationModeEnum.AES);
            LOGGER.debug("===>AesTypeHandler desensitize,column name:{}", field);
            return desensitizationProcessor.desensitize("", field, value);
        } catch (Exception e) {
            LOGGER.error("===>AesTypeHandler desensitize error,column name:{}", field, e);
            return value;
        }
    }
}
