package com.digiwin.dap.middleware.mybatis.config;

import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.mybatis.interceptor.InjectionInterceptor;
import com.digiwin.dap.middleware.mybatis.pagehelper.CustomDialect;
import com.github.pagehelper.PageInterceptor;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import java.util.Properties;

/**
 * @author michael
 */
@Configuration
public class MyBatisConfig {

    private final static Logger LOGGER = LoggerFactory.getLogger(MyBatisConfig.class);

    private final static String MYBATIS_VARIABLES_AES_KEY = "aesKey";

    @Autowired
    private Environment environment;
    /**
     * 防SQL注入拦截器
     *
     * @return org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer
     **/
    @Bean
    public ConfigurationCustomizer sqlInjectionInterceptor() {
        WallConfig config = new WallConfig(MySqlWallProvider.DEFAULT_CONFIG_DIR);
        config.setConditionAndAlwayFalseAllow(true);
        InjectionInterceptor injectionInterceptor = new InjectionInterceptor(config);
        LOGGER.debug("===>MyBatis防SQL注入拦截器初始化");
        return configuration -> configuration.addInterceptor(injectionInterceptor);
    }

    /**
     * 分页拦截器
     *
     * @return org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer
     **/
    @Bean
    @ConditionalOnExpression("#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('pagehelper.helper-dialect'))}")
    public ConfigurationCustomizer pageInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", environment.getProperty("pagehelper.helper-dialect"));
        properties.setProperty("reasonable", environment.getProperty("pagehelper.reasonable"));
        properties.setProperty("supportMethodsArguments", environment.getProperty("pagehelper.support-methods-arguments"));
        properties.setProperty("params", environment.getProperty("pagehelper.params"));
        properties.setProperty("dialect", CustomDialect.class.getName());
        pageInterceptor.setProperties(properties);
        LOGGER.debug("===>MyBatis分页拦截器初始化");
        return configuration -> configuration.addInterceptor(pageInterceptor);
    }

    /**
     * 将aesKey设置为全局变量
     *
     * @return org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer
     **/
    @Bean
    public ConfigurationCustomizer customGlobalVariables() {
        Properties properties = new Properties();
        //  此处不可调用KmsService,KmsService加载顺序在mybatis配置初始化之后,直接调用会查询不到值
        properties.setProperty(MYBATIS_VARIABLES_AES_KEY, KeyConstant.DIGIWIN);
        LOGGER.debug("===>MyBatis设定全局参数");
        return configuration -> configuration.setVariables(properties);
    }

}
