/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.config;

import com.digiwin.dap.middle.database.encrypt.config.DatabaseEncryptConfig;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middleware.mybatis.interceptor.DecryptResultInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={DatabaseEncryptConfig.class})
public class MyBatisEncryptConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyBatisEncryptConfig.class);
    @Autowired
    @Qualifier(value="desensitizationConverter")
    private DesensitizationConverter<Object> desensitizationConverter;
    @Autowired
    @Qualifier(value="sqlParser")
    private SqlParser sqlParser;

    @Bean
    public ConfigurationCustomizer encryptedStorageMyBatisConfigurationCustomizer() {
        LOGGER.debug("===>MyBatis\u52a0\u5bc6\u5b58\u50a8\u76f8\u5173\u63d2\u4ef6\u521d\u59cb\u5316");
        return configuration -> {
            DecryptResultInterceptor decryptResultInterceptor = new DecryptResultInterceptor(this.desensitizationConverter, this.sqlParser);
            configuration.addInterceptor((Interceptor)decryptResultInterceptor);
        };
    }
}

