package com.digiwin.dap.middle.autoconfigure;

import com.digiwin.dap.middle.autoconfigure.config.RamDbConfiguration;
import com.digiwin.dap.middle.autoconfigure.config.RamRedisConfiguration;
import com.digiwin.dap.middle.autoconfigure.config.RamScanConfiguration;
import com.digiwin.dap.middle.autoconfigure.properties.RamType;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

final class RamConfigurations {

    private static final Map<RamType, Class<?>> MAPPINGS;

    static {
        Map<RamType, Class<?>> mappings = new EnumMap<>(RamType.class);
        mappings.put(RamType.SCAN, RamScanConfiguration.class);
        mappings.put(RamType.REDIS, RamRedisConfiguration.class);
        mappings.put(RamType.DB, RamDbConfiguration.class);
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }

    private RamConfigurations() {
    }

    public static String getConfigurationClass(RamType ramType) {
        Class<?> configurationClass = MAPPINGS.get(ramType);
        Assert.state(configurationClass != null, () -> "Unknown ram type " + ramType);
        return configurationClass.getName();
    }

    public static RamType getType(String configurationClassName) {
        for (Map.Entry<RamType, Class<?>> entry : MAPPINGS.entrySet()) {
            if (entry.getValue().getName().equals(configurationClassName)) {
                return entry.getKey();
            }
        }
        throw new IllegalStateException("Unknown configuration class " + configurationClassName);
    }

}
