package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.ram.util.JdbcUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * 数据库初始化
 *
 * @author Seven
 * @date 2021/8/20 11:45
 */
@Configuration
@AutoConfigureAfter({JdbcTemplateAutoConfiguration.class})
public class RamDbConfiguration {

    public RamDbConfiguration(JdbcTemplate jdbcTemplate) {
        JdbcUtils.createTables(jdbcTemplate);
    }
}
