package com.digiwin.dap.middle.autoconfigure.properties;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashSet;
import java.util.Set;

/**
 * Configuration properties for DAP RAM.
 *
 * @author Xiao
 * @date 2021/8/10 16:23
 */
@ConfigurationProperties(prefix = RamProperties.DAP_RAM_PREFIX)
public class RamProperties {

    public static final String DAP_RAM_PREFIX = "dap.middleware.ram";

    /**
     * Whether to enable RAM for middleware.
     */
    private boolean enabled;

    /**
     * Whether to enable cache.
     */
    private boolean cache;

    /**
     * Items to be included in the policy list.
     */
    private Set<PolicyType> policy = new HashSet<>(PolicyType.defaultPolicies());

    /**
     * test
     */
    private String test;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isCache() {
        return cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public Set<PolicyType> getPolicy() {
        return this.policy;
    }

    public void setPolicy(Set<PolicyType> policy) {
        this.policy = policy;
    }

    public String getTest() {
        return test;
    }

    public void setTest(String test) {
        this.test = test;
    }
}
