/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.util.JsonUtils;
import com.digiwin.dap.middle.ram.util.RedisUtils;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@ConditionalOnClass(value={RedisConnectionFactory.class})
@EnableConfigurationProperties(value={RamProperties.class})
public class RamRedisConfiguration {
    @Value(value="${spring.application.name:dap}")
    private String appName;

    @Bean(value={"ramRedisTemplate"})
    public RedisTemplate<String, Object> innerRedisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer(JsonUtils.getRedisSerializer((boolean[])new boolean[0]));
        redisTemplate.afterPropertiesSet();
        RedisUtils.initTemplate((RedisTemplate)redisTemplate);
        return redisTemplate;
    }

    @Bean(value={"ramRedisCacheManager"})
    public RedisCacheManager innerRedisCacheManager(RedisConnectionFactory factory) {
        RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)factory);
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(cacheName -> this.appName + ":ram:" + cacheName + ":").entryTtl(Duration.ofHours(2L)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)JsonUtils.getRedisSerializer((boolean[])new boolean[]{true}))).disableCachingNullValues();
        return RedisCacheManager.builder((RedisCacheWriter)cacheWriter).cacheDefaults(config).build();
    }
}

